 

import java.util.*;
import java.applet.Applet;
import java.awt.Graphics;
import JavaGroups.JavaStack.*;

public class GetGossip extends Applet implements Runnable {
    StringBuffer  buffer;
    GossipClient  srv=null;
    Thread        getter=null;
    final String  groupname="DemoGrp";

    public void init() {
	buffer = new StringBuffer();
	addItem("initializing... ");
	srv=new GossipClient(groupname, "janet", 12001);
    }

    public void start() {
	addItem("starting... ");
	srv.Start();
	if(getter == null) {
	    getter=new Thread(this);
	    getter.start();
	}
    }

    public void stop() {
	addItem("stopping... ");
	if(getter != null) {
	    getter.stop();
	    getter=null;
	}
	srv.Stop();
    }

    public void destroy() {
	addItem("preparing for unloading...");
    }

    void addItem(String newWord) {
	System.out.println(newWord);
	buffer.append(newWord + "\n");
	repaint();
    }

    public void paint(Graphics g) {
	//Draw a Rectangle around the applet's display area.
	g.drawRect(0, 0, getSize().width - 1, getSize().height - 1);

	//Draw the current string inside the rectangle.
	g.drawString(buffer.toString(), 5, 15);
    }


    public void run() {
	Vector v;
	
	while(true) {
	    try {
		if(srv != null) {
		    v=srv.Get(groupname);
		    System.out.println("Adding item " + v);
		    addItem(v.toString());
		}
		Thread.currentThread().sleep(4000);
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }
}
