package JavaGroups;

import java.util.*;


/**
   Contains responses from all members. Marks faulty members.
 */
public class RspList {
    Vector rsps=new Vector();

    
    public void Reset() {rsps.removeAllElements();}
    

    public void AddRsp(Object sender, Object retval) {
	Rsp rsp=(Rsp)Find(sender);
	
	if(rsp != null) {
	    rsp.sender=sender; rsp.retval=retval; rsp.received=true; rsp.suspected=false;
	    return;
	}
	rsps.addElement(new Rsp(sender, retval));
    }


    public void AddNotReceived(Object sender) {
	Rsp rsp=(Rsp)Find(sender);

	if(rsp == null)
	    rsps.addElement(new Rsp(sender));
    }



    public void AddSuspect(Object sender) {
	Rsp rsp=(Rsp)Find(sender);
	
	if(rsp != null) {
	    rsp.sender=sender; rsp.retval=null; rsp.received=false; rsp.suspected=true;
	    return;
	}
	rsps.addElement(new Rsp(sender, true));
    }


    public boolean IsReceived(Object sender) {
	Rsp rsp=(Rsp)Find(sender);

	if(rsp ==null) return false;
	return rsp.received;
    }


    public int NumSuspectedMembers() {
	int  num=0;
	Rsp  rsp;

	for(int i=0; i < rsps.size(); i++) {
	    rsp=(Rsp)rsps.elementAt(i);
	    if(rsp.WasSuspected())
		num++;
	}
	return num;
    }

    /**
       Returns the results from non-suspected members that are not null.
     */
    public Vector GetResults() {
	Vector ret=new Vector();
	Rsp    rsp;
	Object val;
	
	for(int i=0; i < rsps.size(); i++) {
	    rsp=(Rsp)rsps.elementAt(i);
	    if(rsp.WasReceived() && (val=rsp.GetValue()) != null)
		ret.addElement(val);
	}
	return ret;
    }


    public Vector GetSuspectedMembers() {
	Vector retval=new Vector();
	Rsp    rsp;
	
	for(int i=0; i < rsps.size(); i++) {
	    rsp=(Rsp)rsps.elementAt(i);
	    if(rsp.WasSuspected())
		retval.addElement(rsp);
	}
	return retval;
    }

    
    public boolean IsSuspected(Object sender) {
	Rsp rsp=(Rsp)Find(sender);

	if(rsp ==null) return false;
	return rsp.suspected;
    }


    public Object Get(Object sender) {
	Rsp rsp=(Rsp)Find(sender);

	if(rsp == null) return null;
	return rsp.retval;
    }


    public int size() {return rsps.size();}

    public Object elementAt(int i) throws ArrayIndexOutOfBoundsException {
	return rsps.elementAt(i);
    }


    public String toString() {
	StringBuffer ret=new StringBuffer();
	Rsp          rsp;
	Object       sender;

	for(int i=0; i < rsps.size(); i++) {
	    rsp=(Rsp)rsps.elementAt(i);
	    ret.append("[" + rsp + "]\n");
	}
	return ret.toString();
    }





    boolean Contains(Object sender) {
	Rsp rsp;

	for(int i=0; i < rsps.size(); i++) {
	    rsp=(Rsp)rsps.elementAt(i);
	    if(rsp.sender != null && sender != null && rsp.sender.equals(sender))
		return true;
	}
	return false;
    }


    Rsp Find(Object sender) {
	Rsp rsp;

	for(int i=0; i < rsps.size(); i++) {
	    rsp=(Rsp)rsps.elementAt(i);
	    if(rsp.sender != null && sender != null && rsp.sender.equals(sender))
		return rsp;
	}
	return null;
    }





    public static void main(String[] args) {
	RspList l=new RspList();
	
	l.AddRsp("Bela Ban", new Integer(33));
	l.AddRsp("Jeannette Fechner", new Integer(31));
	l.AddRsp("Peter", null);
	l.AddSuspect("Hans");
	l.AddSuspect("Jeannette Fechner");

	System.out.println(l);

	for(int i=0; i < l.size(); i++)
	    System.out.println("Rsp #" + i + ": " + l.elementAt(i));
    }

}
