package JavaGroups;

import java.util.*;


public class Queue {
    private Vector  messages=new Vector();
    private boolean closed=false;
    private int     num_markers=0;
    
    private class _EndMarker {}


    public void Add(Object msg) throws QueueClosed {
	if(closed)
	    throw new QueueClosed();
	synchronized(messages) {
	    messages.addElement(msg);
	    Notify();
	}
    }


    public Object Remove() throws QueueClosed {  // removes from head, or blocks
	Object retval=null;
	synchronized(messages) {
	    while(messages.size() == 0) {
		if(closed)
		    throw new QueueClosed();
		try {
		    messages.wait();
		}
		catch(IllegalMonitorStateException ex) {
		    throw ex;
		}
		catch(Exception ex) {
		    System.err.println(ex);
		}
	    }
	    if(closed)
		throw new QueueClosed();
	    retval=messages.elementAt(0);
	    messages.removeElementAt(0);

	    if(retval instanceof _EndMarker) {
		Close(false); // mark queue as closed
		throw new QueueClosed();
	    }

	    return retval;
	}
    }



    public Object Peek() throws QueueClosed {  // removes from head, or blocks
	Object retval=null;
	synchronized(messages) {
	    while(messages.size() == 0) {
		if(closed)
		    throw new QueueClosed();
		try {
		    messages.wait();
		}
		catch(IllegalMonitorStateException ex) {
		    throw ex;
		}
		catch(Exception ex) {
		    System.err.println(ex);
		}
	    }
	    if(closed)
		throw new QueueClosed();
	    retval=messages.elementAt(0);

	    if(retval instanceof _EndMarker) {
		Close(false);
		throw new QueueClosed();
	    }

	    return retval;
	}
    }


    public Object Remove(long timeout) throws QueueClosed, Timeout {
	Object retval=null;
	synchronized(messages) {
	    if(messages.size() == 0) {
		if(closed)
		    throw new QueueClosed();
		try {
		    messages.wait(timeout);
		}
		catch(IllegalMonitorStateException ex) {
		    throw ex;
		}
		catch(IllegalArgumentException ex2) {
		    throw ex2;
		}
		catch(Exception e) {
		    System.err.println(e);
		}
	    }
	    if(closed)
		throw new QueueClosed();
	    if(messages.size() > 0) {
		retval=messages.elementAt(0);
		messages.removeElementAt(0);

		if(retval instanceof _EndMarker) {
		    Close(false);
		    throw new QueueClosed();
		}
	    }
	    else
		throw new Timeout();
	    return retval;
	}
    }



    /** Doesn't remove element */
    public Object Peek(long timeout) throws QueueClosed, Timeout {
	Object retval=null;
	synchronized(messages) {
	    if(messages.size() == 0) {
		if(closed)
		    throw new QueueClosed();
		try {
		    messages.wait(timeout);
		}
		catch(IllegalMonitorStateException ex) {
		    throw ex;
		}
		catch(IllegalArgumentException ex2) {
		    throw ex2;
		}
		catch(Exception e) {
		    System.err.println(e);
		}
	    }
	    if(closed)
		throw new QueueClosed();
	    if(messages.size() > 0) {
		retval=messages.elementAt(0);
		if(retval instanceof _EndMarker) {
		    Close(false);
		    throw new QueueClosed();
		}
	    }
	    else
		throw new Timeout();
	    return retval;
	}
    }



    /**
       Marks the queues as closed. When an <code>Add</code> or <code>Remove</code> operation is
       attempted on a closed queue, an exception is thrown.
       @param flush_entries When true, a end-of-entries marker is added to the end of the queue.
                            Entries may be added and removed, but when the end-of-entries marker
			    is encountered, the queue is marked as closed. This allows to flush
			    pending messages before clsing the queue.
     */
    public synchronized void Close(boolean flush_entries) {
	if(flush_entries) {
	    try {
		Add(new _EndMarker()); // add an end-of-entries marker to the end of the queue
		num_markers++;
	    }
	    catch(QueueClosed closed) {}
	    return;
	}

	synchronized(messages) {
	    closed=true;
	    try {
		messages.notifyAll();
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }



    public synchronized void Reset() {
	num_markers=0;
	if(!closed)
	    Close(false);

	synchronized(messages) {
	    messages.removeAllElements();
	}
	closed=false;
    }


    protected void Notify() {  // Data is available
	synchronized(messages) {
	    // messages.notifyAll();
	    messages.notify();   // only wake up next thread in line
	}
    }

    public int Size() {
	return messages.size() - num_markers;
    }

    public String toString() {
	return "Queue (" + Size() + ") messages";
    }



    public Vector GetContents() {return messages;}


    public static void main(String[] args) {
	Queue q=new Queue();

	for(int i=0; i < 5; i++) {
	    try {
		q.Add(new String("Bela #" + (i+1)));
		System.out.println(q);
	    }
	    catch(QueueClosed closed) {
		System.err.println(closed);
		break;
	    }
	}





	for(int i=0; i < 5; i++) {
	    try {
		System.out.println(q.Remove());
		q.Close(true);
	    }
	    catch(QueueClosed closed) {
		System.err.println("Queue is closed");
		break;
	    }
	}



    }



}
