package JavaGroups;


/**
 * Merely used for configuration purposes instead of configuration files that are parsed
 * at start time.
 */
public class Conf {
    

    /**
     * Message types (Message.type)
     * IDs 0-9 are reserved. Protocol layers start from 10. Each new protocol must register 
     * its ID here. IDs must be unique.
     */
    public static final int DEFAULT_MSG  =  0;
    public static final int GMS_MSG      =  1;
    public static final int FD_MSG       =  2;


    public static String Type2String(int t) {	
	switch(t) {
	case Conf.DEFAULT_MSG:   return "default_msg";
	case Conf.GMS_MSG:       return "gms_msg";
	case Conf.FD_MSG:        return "fd_msg";
	default:   	         return "unknown_msg (" + t + ")";
	}
    }

}
