package JavaGroups;

import java.util.*;

class ChannelEntry implements MessageListener {
    protected Channel            channel=null;
    protected String             channel_name=null;
    protected int                use_count=0;
    protected MessageCorrelator  corr=new MessageCorrelator();
    protected PullPushAdapter    pull_push=null;
    protected MethodInvoker      method_invoker=null;


    public int                GetUseCount()           {return use_count;}
    public MessageCorrelator  GetMessageCorrelator()  {return corr;}
    public Channel            GetChannel()            {return channel;}


    /** Channel must NOT be connected ! */
    public ChannelEntry(Channel channel, String name, MethodLookup method_lookup) throws Exception {
	// 1. Create a new PullPushAdapter on the channel with me as MessageListener
	//    (this will send messages to Receive())
	// 2. Create a MethodInvoker

	this.channel=channel;
	channel_name=name;
	channel.Connect(channel_name);
	method_invoker=new MethodInvoker(channel, false);  // don't create internal PullPushAd. !
	method_invoker.SetMethodLookup(method_lookup);
	pull_push=new PullPushAdapter(channel);
	pull_push.SetListener(this);                       // redirects messages to Receive()
    }


    public Object GetAddress()    {return channel != null ? channel.GetLocalAddress() : null;}
    public void HoldRequests()    {method_invoker.HoldRequests();}
    public void ReleaseRequests() {method_invoker.ReleaseRequests();}

    public void Destroy() {
	pull_push.Stop();
	corr.Stop();
	method_invoker.RemoveAllTargetObjects();
	try {
	    channel.Disconnect();
	}
	catch(Exception e) {
	    System.err.println("ChannelEntry.Destroy(): " + e);
	}
	
    }


    public void Add(Object obj) {
	method_invoker.AddTargetObject(obj);
	use_count++;
    }

    public void Remove(Object obj) {
	method_invoker.RemoveTargetObject(obj);
	use_count--;
    }
    

    public void AddFunclet(Object target, String funclet_name, Object funclet) {
	method_invoker.AddFunclet(target, funclet_name, funclet);
    }

    
    public void SetMembershipListener(MembershipListener ml) {
	pull_push.SetMembershipListener(ml);
    }


    public void Receive(Message msg) {
	// If request: call method_invoker.Receive()
	// If response: add to message correlator

	try {
	    if(msg.IsResponse())
		corr.AddResponse(msg);
	    else
		method_invoker.Receive(msg);
	}
	catch(Exception e) {
	    System.err.println("ChannelEntry.Receive(): " + e);
	}
    }

}


