/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups;

import JavaGroups.Address;
import JavaGroups.Message;
import JavaGroups.MethodCall;
import JavaGroups.UnicastAddress;
import java.io.Serializable;

public class RpcMessage
extends Message {
    private boolean oneway = false;

    public RpcMessage() {
    }

    public RpcMessage(boolean oneway) {
        this.oneway = oneway;
    }

    public RpcMessage(byte[] msg) {
        super(msg);
    }

    public RpcMessage(Address dest) {
        super(dest);
    }

    public RpcMessage(Serializable msg) {
        super(msg);
    }

    public RpcMessage(Address dest, byte[] d) throws Exception {
        super(dest, d);
    }

    public RpcMessage(Address dest, Serializable msg) {
        super(dest, msg);
    }

    public RpcMessage(Address dest, Address src) throws Exception {
        super(dest, src);
    }

    public RpcMessage(Address dest, Address src, byte[] d) throws Exception {
        super(dest, src, d);
    }

    public RpcMessage(Address dest, Address src, Serializable msg) throws Exception {
        super(dest, src, msg);
    }

    public boolean IsOneway() {
        return this.oneway;
    }

    public void SetOneway(boolean f) {
        this.oneway = f;
    }

    public void SetMethodCall(MethodCall m) {
        this.SetObject(m);
    }

    public MethodCall GetMethodCall() {
        return (MethodCall)this.GetObject();
    }

    public void SetObject(Serializable obj) {
        if (!(obj instanceof MethodCall)) {
            System.err.println("RpcMessage.SetObject(): arg is not of type RpcMessage !");
            return;
        }
        super.SetObject(obj);
    }

    public void SetResponse(Serializable obj) {
        super.SetObject(obj);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("RpcMessage, ");
        ret.append(super.toString());
        Object tmp = this.ReadObject();
        if (tmp != null) {
            if (this.IsResponse()) {
                ret.append("Response: " + tmp.toString());
            } else {
                MethodCall descr = (MethodCall)tmp;
                ret.append("\n" + descr);
            }
        }
        return ret.toString();
    }

    public Message MakeReply() {
        RpcMessage ret = new RpcMessage();
        ret.reply_id = this.msg_id;
        ret.dest_addr = this.source_addr;
        ret.source_addr = null;
        return ret;
    }

    public Object clone() throws CloneNotSupportedException {
        RpcMessage retval = null;
        Address dest = this.dest_addr != null ? (Address)this.dest_addr.clone() : null;
        Address src = this.source_addr != null ? (Address)this.source_addr.clone() : null;
        try {
            retval = new RpcMessage(dest, src, this.GetData());
            retval.SetMessageId(this.msg_id);
            retval.SetOneway(this.oneway);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return retval;
    }

    public static void main(String[] args) {
        try {
            RpcMessage m = new RpcMessage((Address)new UnicastAddress("janet", 8899), new UnicastAddress("janet", 3333));
            m.SetOneway(false);
            MethodCall descr = new MethodCall("Foo");
            descr.AddArg("Bela Ban");
            descr.AddArg(322649);
            m.SetMethodCall(descr);
            System.out.println(m);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

