/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Vector;

public class MethodCall
implements Serializable {
    private String method_name;
    private Vector formal_args = new Vector();
    private Vector args = new Vector();

    public MethodCall(String name) {
        this.method_name = name;
    }

    public MethodCall(String name, Object arg1) {
        this(name);
        this.AddArg(arg1);
    }

    public MethodCall(String name, Object arg1, Object arg2) {
        this(name, arg1);
        this.AddArg(arg2);
    }

    public MethodCall(String name, Object arg1, Object arg2, Object arg3) {
        this(name, arg1, arg2);
        this.AddArg(arg3);
    }

    public String GetName() {
        return this.method_name;
    }

    public void SetName(String n) {
        this.method_name = n;
    }

    public void AddArg(Object arg) {
        this.formal_args.addElement(arg.getClass());
        this.args.addElement(arg);
    }

    public void AddArg(byte b) {
        Byte obj = new Byte(b);
        this.formal_args.addElement(obj.getClass());
        this.args.addElement(obj);
    }

    public void AddArg(char c) {
        Character obj = new Character(c);
        this.formal_args.addElement(obj.getClass());
        this.args.addElement(obj);
    }

    public void AddArg(boolean b) {
        Boolean obj = new Boolean(b);
        this.formal_args.addElement(obj.getClass());
        this.args.addElement(obj);
    }

    public void AddArg(int i) {
        Integer obj = new Integer(i);
        this.formal_args.addElement(obj.getClass());
        this.args.addElement(obj);
    }

    public void AddArg(long l) {
        Long obj = new Long(l);
        this.formal_args.addElement(obj.getClass());
        this.args.addElement(obj);
    }

    public Object Invoke(Object target) {
        Class<?> cl = target.getClass();
        Object retval = null;
        if (this.method_name == null) {
            System.out.println("Method name is not provided");
            return null;
        }
        try {
            Method meth;
            Class[] class_args = new Class[this.formal_args.size()];
            int i = 0;
            while (i < this.formal_args.size()) {
                class_args[i] = (Class)this.formal_args.elementAt(i);
                ++i;
            }
            try {
                meth = cl.getMethod(this.method_name, class_args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("Found no method called " + this.method_name + " in class " + cl.getName() + " with " + this.formal_args + " formal parameters");
                return null;
            }
            Object[] obj_args = new Object[this.args.size()];
            int i2 = 0;
            while (i2 < this.args.size()) {
                obj_args[i2] = this.args.elementAt(i2);
                ++i2;
            }
            retval = meth.invoke(target, obj_args);
            return retval;
        }
        catch (Exception e) {
            System.err.println(e);
            return retval;
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("MethodCall (name=" + this.method_name);
        ret.append(", number of args=" + this.args.size() + ")");
        ret.append("\nArgs:");
        int i = 0;
        while (i < this.args.size()) {
            ret.append("\n[" + this.args.elementAt(i) + " (" + ((Class)this.formal_args.elementAt(i)).getName() + ")]");
            ++i;
        }
        return ret.toString();
    }
}

