
import java.net.*;

public class Mcast implements Runnable {

    private InetAddress      mcast_addr;
    private int              port=-1;
    private MulticastSocket  sock=null;    
    private DatagramSocket   outsock=null;
    private Receiver         receiver=null;

    private class Receiver extends Thread {

	public boolean FromMe(DatagramPacket packet) throws Exception {

	    //System.out.println("FromMe: " + packet.getAddress() + ":" + 
	    //		       packet.getPort());

	    InetAddress me=InetAddress.getLocalHost();
	    if(packet.getAddress().equals(me) && packet.getPort() == outsock.getLocalPort())
		return true;
	    return false;
	}
	
	public void run() {
	    int             i=0;
	    byte            buf[]=new byte[10000];
	    DatagramPacket  in_packet;
	    String          tmp;
	    while(true) {
		try {
		    in_packet=new DatagramPacket(buf, buf.length);
		    sock.receive(in_packet);
		    if(FromMe(in_packet))
			continue;
		    tmp=new String(in_packet.getData());
		    System.out.println("Received " + tmp + " from " + 
				       in_packet.getAddress() + ":" + in_packet.getPort());
		}
		catch(Exception e) {
		    System.err.println(e);
		}	    
	    }
	}
	
    }


    public Mcast(String addr, int p) throws Exception {
	mcast_addr=InetAddress.getByName(addr);
	port=p;
	sock=new MulticastSocket(port);
	sock.joinGroup(mcast_addr);
	receiver=new Receiver();
	receiver.start();
    }


    public void run() {
	String          m="Hello #";
	DatagramPacket  packet;
	byte            msg[];
	int             i=0;

	try {
	    outsock=new DatagramSocket();
	}
	catch(Exception e) {
	    System.err.println(e);
	}	

	try {
	    while(true) {		
		msg=(m+i).getBytes();
		packet=new DatagramPacket(msg, msg.length, mcast_addr, port);
		outsock.send(packet);
		System.out.println("Sent msg #" + i++);
		Thread.currentThread().sleep(1000);
	    }
	}
	catch(Exception e) {
	    System.err.println(e);
	}	
    }


    public static void main(String args[]) {
	if(args.length != 2) {
	    System.err.println("Mcast <multicast address> <port>");
	    System.exit(0);
	}
	Mcast  mc;
	Thread t;

	try {
	    mc=new Mcast(args[0], Integer.parseInt(args[1]));
	    t=new Thread(mc);
	    t.start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}	
    }

    
}
