package JavaGroups;

import java.io.*;
import java.util.Vector;


/**
 * Collection of various utility routines that can not be assigned to other classes.
 */
public class Util {


    /**
     * Creates an object from a byte buffer
     */
    public static Object ObjectFromByteBuffer(byte[] buffer) throws Exception {
	Object               retval=null;
	ByteArrayInputStream in_stream=new ByteArrayInputStream(buffer);
	ObjectInputStream    in=new ObjectInputStream(in_stream);	
	retval=in.readObject();
	if(retval == null)
	    return null;
	return retval;
    }

    /**
     * Serializes an object into a byte buffer. 
     * The object has to implement interface Serializable.
     */
    public static byte[] ObjectToByteBuffer(Serializable obj) throws Exception {
	ByteArrayOutputStream out_stream=new ByteArrayOutputStream();
	ObjectOutputStream    out=new ObjectOutputStream(out_stream);	
	out.writeObject(obj);
	return out_stream.toByteArray();
    }


    public static void Sleep(long timeout) {
	try {
	    Thread.currentThread().sleep(timeout);
	}
	catch(Exception e) {}
    }


    public static void DumpStack(boolean exit) {
	try {
	    throw new Exception("Dumping stack:");
	}
	catch(Exception e) {
	    e.printStackTrace();
	    if(exit)
		System.exit(0);
	}
    }

    public static void Print(String msg) {
	System.out.println(msg); System.out.flush();
    }



    public static void PrintThreads() {
	Thread threads[]=new Thread[Thread.activeCount()];
	int num=Thread.enumerate(threads);
	System.out.println("------- Threads -------");
	for(int i=0; i < threads.length; i++) {
	    System.out.println("#" + i + ": " + threads[i]);
	}
	System.out.println("------- Threads -------\n");
    }





    /**
       Fragments a byte buffer into smaller fragments of (max.) frag_size.
       Example: a byte buffer of 1024 bytes and a frag_size of 248 gives 4 fragments
       of 248 bytes each and 1 fragment of 32 bytes.
       @return A vector of byte buffers (<code>byte[]</code>).
     */
    public static Vector FragmentBuffer(byte[] buf, int frag_size) {
	Vector                retval=new Vector();
	long                  total_size=buf.length, accumulated_size=0;
	byte[]                fragment;
	int                   tmp_size=0;
	ByteArrayInputStream  in;

	in=new ByteArrayInputStream(buf);
	
	while(accumulated_size < total_size) {
	    if(accumulated_size + frag_size <= total_size)
		tmp_size=frag_size;
	    else
		tmp_size=(int)(total_size - accumulated_size);

	    // System.out.println("Util.FragmentBuffer(): tmp_size is " + tmp_size);

	    fragment=new byte[tmp_size];
	    
	    int bytes_read=in.read(fragment, 0, tmp_size);

	    retval.addElement(fragment);
	    accumulated_size+=tmp_size;
	}


	return retval;
    }

    /**
       Concatenates smaller fragments into entire buffers.
       @param fragments A vector of byte buffers (<code>byte[]</code>)
       @return A byte buffer
     */
    public static byte[] DefragmentBuffer(Vector fragments) {
	long                  total_size=0;
	ByteArrayOutputStream out=new ByteArrayOutputStream();
	byte[]                tmp;

	for(int i=0; i < fragments.size(); i++) {
	    tmp=(byte[])fragments.elementAt(i);
	    out.write(tmp, 0, tmp.length);
	}
	return out.toByteArray();
    }


    public static void PrintFragments(Vector frags) {
	for(int i=0; i < frags.size() ;i++)
	    System.out.println("'" + new String(((byte[])frags.elementAt(i))) + "'");
    }


    
    /**
       Peeks for view on the channel until n views have been received or timeout has elapsed.
       Used to determine the view in which we want to start work. Usually, we start as only
       member in our own view (1st view) and the next view (2nd view) will be the full view
       of all members, or a timeout if we're the first member. If a non-view (a message or
       block) is received, the method returns immediately.
       @param channel The channel used to peek for views. Has to be operational.
       @param number_of_views The number of views to wait for. 2 is a good number to ensure that,
              if there are other members, we start working with them included in our view.
       @param timeout Number of milliseconds to wait until view is forced to return. A value
              of <= 0 means wait forever.
     */
    public static View PeekViews(Channel channel, int number_of_views, long timeout) {
	View     retval=null;
	Object   obj=null;
	int      num=0;
	long     start_time=System.currentTimeMillis();

	if(timeout <= 0) {
	    while(true) {
		try {
		    obj=channel.Peek(0);
		    if(obj == null || !(obj instanceof View))
			break;
		    else {
			retval=(View)channel.Receive(0);
			num++;
			if(num >= number_of_views)
			    break;
		    }
		}
		catch(Exception ex) {
		    break;
		}
	    }
	}
	else {
	    while(timeout > 0) {
		try {
		    obj=channel.Peek(timeout);
		    if(obj == null || !(obj instanceof View))
			break;
		    else {
			retval=(View)channel.Receive(timeout);
			num++;
			if(num >= number_of_views)
			    break;
		    }
		}
		catch(Exception ex) {
		    break;
		}
		timeout=timeout - (System.currentTimeMillis() - start_time);
	    }
	}

	return retval;
    }




    public static void main(String args[]) {
	byte[] buf=new String("Hello world from Bela Ban and Jeannette Fechner").getBytes();
	Vector fragments=FragmentBuffer(buf, 8);
	System.out.println("length: " + buf.length);
	System.out.println(fragments.size() + " fragments");
	PrintFragments(fragments);


	byte[] new_buf=DefragmentBuffer(fragments);
	System.out.println("Result is: '" + new String(new_buf) + "' (Length: " + 
			   new_buf.length + ")");

    }

}
