
import java.net.*;
import java.util.*;
import JavaGroups.*;


public class SyncSendChannelMult {

    public void Start() throws Exception {
	Channel  channel=new JChannel(null);
	SyncCall sync_call;
	Message  msg, rsp, tmp;
	Vector   retval;

	channel.Connect("SyncCallTest");
	sync_call=new SyncCall(channel);

	
	for(int i=1; i <= 5; i++) {
	    System.out.println("\nSending synchronous message #" + i +
			       " to group, receiving all replies");
	    retval=sync_call.SendGetN(new String("Hello world").getBytes(), 
				      channel.GetView().Size()-1, 6000);
	    if(retval == null)
		System.err.println("Received no responses");
	    else {
		System.out.println("Received " + retval.size() + " reponses:");
		for(int j=0; j < retval.size(); j++) {
		    tmp=(Message)retval.elementAt(j);
		    System.out.println("ID: " + tmp.GetId() + " from " + tmp.GetSrc());
		}
	    }
	    
	}
	channel.Disconnect();
    }




    public static void main(String args[]) {
	SyncSendChannelMult t;
	try {
	    t=new SyncSendChannelMult();
	    t.Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}		
    }






    public static void active() {
	System.out.println(Thread.activeCount() + " active threads");
	PrintThreads();
    }



    public static void PrintThreads() {
	Thread threads[]=new Thread[Thread.activeCount()];
	int num=Thread.enumerate(threads);
	System.out.println("------- Threads -------");
	for(int i=0; i < threads.length; i++) {
	    System.out.println("#" + i + ": " + threads[i]);
	}
	System.out.println("------- Threads -------\n");
    }


    
}
