
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import JavaGroups.*;
import JavaGroups.GMP.*;




public class Topology extends Frame implements WindowListener, FailureDetectorListener {
    private Vector       members;
    private Graphics     g;
    private Font         font;
    private FontMetrics  fm;
    private Color        node_color=new Color(250, 220, 100);
    private boolean      coordinator=false;
    private OID          curr_hb=null, current_check=null;
    private final int    NormalStyle=0;
    private final int    CheckStyle=1;
    private final int    HeartbeatStyle=2;



    public Topology() {
	addWindowListener(this);
	g=getGraphics();
	fm=getFontMetrics(new Font("TimesRoman", Font.BOLD,12));
	font=new Font("TimesRoman",Font.BOLD,12);

    }

    public void SetState(Vector mbrs) {
	members=mbrs;
	repaint();
    }

    public void AddNode(UnicastAddress member) {
	members.addElement(member);
	repaint();
    }

    public void RemoveNode(UnicastAddress member) {
	members.removeElement(member);
	repaint();
    }    


    public void DrawNode(Graphics g, int x, int y, String label, int style) {
	Color old=g.getColor();
	int width, height;

	width=fm.stringWidth(label) + 10;
	height=fm.getHeight()+5;

	switch(style) {
	case HeartbeatStyle:
	    g.setColor(Color.green);
	    break;
	case CheckStyle:
	default:
	    g.setColor(node_color);
	    break;
	}

	g.fillRect(x, y, width, height);
	g.setColor(old);
	g.drawString(label, x+5, y+15);
	g.drawRoundRect(x-1, y-1, width+1, height+1, 10, 10);
	if(style == CheckStyle) {
 	   g.drawRoundRect(x-2, y-2, width+2, height+2, 10, 10);
	   g.drawRoundRect(x-3, y-3, width+3, height+3, 10, 10);
	}
    }



    public void DrawTopology(Graphics g) {
	int        x=20, y=50;
	String     label;
	Dimension  box=getSize();
	Color      old=g.getColor();
	OID        tmp_oid;
	
	if(coordinator) {
	    g.setColor(Color.cyan);
	    g.fillRect(11, 31, box.width-21, box.height-61);
	    g.setColor(old);
	}
	

	g.drawRect(10, 30, box.width-20, box.height-60);

	g.setFont(font);

	for(int i=0; i < members.size(); i++) {
	    tmp_oid=((UnicastAddress)members.elementAt(i)).GetOid();
	    label=tmp_oid.toString();

	    if(current_check != null && current_check == tmp_oid)
		DrawNode(g, x, y, label, CheckStyle);
	    else if(curr_hb != null && curr_hb == tmp_oid)
		DrawNode(g, x, y, label, HeartbeatStyle);
	    else
		DrawNode(g, x, y, label, NormalStyle);

	    y+=50;
	}
	

	
    }

    
    public void paint(Graphics g) {
	// g.drawString("I have " + members.size() + " members", 30, 70);
	DrawTopology(g);
    }


    /* ------------ Callbacks ------------- */

    public void ReceivedHeartbeat(OID obj) {
	curr_hb=obj;
	repaint();
	try {
	    Thread.currentThread().sleep(500);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	curr_hb=null;
	repaint();
    }

    public void CoordinatorChosen() {
	coordinator=true;
	repaint();
    }

    public void CheckForCoord(OID obj) {
	current_check=obj;
	repaint();
	try {
	    Thread.currentThread().sleep(500);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	current_check=null;
	repaint();
    }

    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
	System.exit(0);
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}
}


