

import java.io.*;
import java.util.Date;
import JavaGroups.*;
import JavaGroups.JavaStack.*;



class DummyChannel extends JChannel {
    RequestCorrelator  corr=null;
    

    public DummyChannel(boolean dummy) throws ChannelException {super(false);}
    public DummyChannel() throws ChannelException {}    
    public DummyChannel(Object props) throws ChannelException {}


    public void SetCorr(RequestCorrelator corr) {this.corr=corr;}
    

    public void Up(Event evt) {  // callback
	Message msg;

	if(corr != null) {
	    switch(evt.GetType()) {
	    case Event.MSG:
		corr.Receive((Message)evt.GetArg());
		break;
	    case Event.SUSPECT:
		corr.Suspect(evt.GetArg());
		break;
	    default:
		break;
	    }
	}
    }

}



class DummyProtocol extends Protocol implements Transport {
    Protocol prot_stack=null;

    public DummyProtocol(Protocol prot_stack) {this.prot_stack=prot_stack;}

    /* --------------------- Transport interface -------------------- */
    public void Send(Message msg) throws Exception {
	PassDown(new Event(Event.MSG, msg));
    }
    public Object Receive(long timeout) throws Exception {
	throw new Exception("Not implemented");
    }
    /* ----------------- End of Transport interface ----------------- */


    public String   GetName() {return "DummyProtocol";}
    public void     PassDown(Event evt) {prot_stack.Down(evt);}
    public void     PassUp(Event evt) {}
}





class Request implements Serializable {
    public static final int GET_DATE=1;

    int type=GET_DATE;

    public Request() {}
    public Request(int type) {this.type=type;}
}






public class RequestCorrTest implements RequestHandler, RspCollector {
    RequestCorrelator  corr;
    ProtocolStack      stack;
    DummyChannel       channel;
    DummyProtocol      prot;
    

    public void ReceiveResponse(Message msg) {
	try {
	    System.out.println("Received rsp: " + Util.ObjectFromByteBuffer(msg.GetBuffer()));
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }


    public void Suspect(Object mbr) {
	System.out.println("Object " + mbr + " is suspected");
    }



    /** Handle requests */
    public Object Handle(Message msg) {
	Request  req;
	Object   retval=null;

	try {
	    req=(Request)Util.ObjectFromByteBuffer(msg.GetBuffer());
	    switch(req.type) {
	    case Request.GET_DATE:
		retval=new Date();
		break;
	    default:
		break;
	    }
	}
	catch(Exception e) {
	    System.err.println("RequestCorrTest.Handle(): " + e);
	}

	return retval;
    }




    public void Start(String role) throws Exception {
	channel=new DummyChannel(false);
	stack=new ProtocolStack(channel, "UDP:FD:GMS");
	prot=new DummyProtocol(stack);
	corr=new RequestCorrelator(prot, this);
	channel.SetCorr(corr);
	stack.Start();
	stack.Down(new Event(Event.CONNECT, "BelaGrp"));

	if(role != null && role.equals("sender")) {
	    Message req=new Message(null, null, new Request(Request.GET_DATE));
	    corr.SendRequest(322649, req, this);	    
	}
    }






    public static void main(String[] args) {
	if(args.length != 1) {
	    System.err.println("RequestCorrTest <'sender' | 'receiver'>");
	    return;
	}
	if(!args[0].equals("sender") && !args[0].equals("receiver")) {
	    System.err.println("RequestCorrTest <'sender' | 'receiver'>");
	    return;
	}
	try {
	    new RequestCorrTest().Start(args[0]);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }

}
