
import java.util.*;

import JavaGroups.Ensemble.*;
import JavaGroups.*;

public class OutboardTest implements Hot_Callbacks, Runnable {
    private Hot_Ensemble      ensemble=null;
    private Thread            ens_thread=null;
    private Hot_GroupContext  group_id=null;
    private Hot_JoinOps       options=new Hot_JoinOps();    
    private Thread            my_thread=null;    
    private boolean           blocked=false;
    private String            greeting="Hello world";

    public OutboardTest() {
	ensemble=new Hot_Ensemble();
	ensemble.setDebug(false);
	ens_thread=new Thread(ensemble);
    }

    public OutboardTest(int port, String g) {
	greeting=g;
	ensemble=new Hot_Ensemble(port);
	ensemble.setDebug(false);
	ens_thread=new Thread(ensemble);
    }


    public void Start() {
	Hot_Error           rc;
	Hot_GroupContext[]  tmp=new Hot_GroupContext[1];


	options.heartbeat_rate=5000;
	options.transports="UDP";
	options.protocol="Top:Heal:Switch:Leave:Inter:Intra:Elect:Merge:" + 
	    "Sync:Suspect:Top_appl:Pt2ptw:Pt2pt:Frag:Stable:Mnak:Bottom";
	options.group_name="OutboardTestGroup";
	options.params="primary_quorum=2:int;suspect_max_idle=3:int;suspect_sweep=3.000:time";
	options.conf=this;
	options.use_properties=true;

	ens_thread.start();

	rc=ensemble.Join(options, tmp);
	if(rc != null) {
	    System.out.println("JOIN failed: " + rc);
	    System.exit(-1);
	}
	else
	    System.out.println("JOIN successful, group_id=" + tmp[0]);
	group_id=tmp[0];


	System.out.println("Starting my looping thread");
	my_thread=new Thread(this);
	my_thread.start();
    }


    public void run() {
	Hot_Error          rc;
	int                tmp[]=new int[1]; tmp[0]=0;
	Hot_Message        msg=null;
	byte[]             bytes=null;

	for(;;) {

	    bytes=new byte[50000];
	    for(int i=0; i < bytes.length; i++)
		bytes[i]=0;

	    msg=new Hot_Message();
	    msg.setBytes(bytes);


	    System.out.println("Sending " + msg.getLength() + " bytes:"); 
	    rc=ensemble.Cast(group_id, msg, tmp);
 	    if(rc != null)
 		System.err.println("Cast failed: " + rc);

	    try {
		Thread.currentThread().sleep(10);
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }


    
    public void ReceiveCast(Hot_GroupContext gctx, Object env, 
			    Hot_Endpoint origin, Hot_Message msg) {

	System.out.println("++++++ Received " + msg.getLength() + " bytes: " + 
			   new String(msg.getBytes()));

	//	Hot_ObjectMessage m=new Hot_ObjectMessage(msg);
	//	Object            o=m.getObject();
	//	System.out.println("Received " + o);
    }


    public void ReceiveSend(Hot_GroupContext gctx, Object env, 
			    Hot_Endpoint origin, Hot_Message msg) {
	
    }


    public void AcceptedView(Hot_GroupContext gctx, Object env, Hot_ViewState viewState) {
	// System.out.println("Accepted new view"); // + viewState);
	System.out.println("--> AcceptedView. Setting blocked to false");
    }


    public void Heartbeat(Hot_GroupContext gctx, Object env, int rate) {
	// System.out.println("Received heartbeat: gctx=" + gctx + ", env=" + env +
	//			   ", rate=" + rate);
    }


    public void Block(Hot_GroupContext gctx, Object env) {
	System.out.println("--> Block. Setting blocked to true");
    }


    public void Exit(Hot_GroupContext gctx, Object env) {
	
    }


    public static void main(String args[]) {
	int           port=0;
	String        greeting="Hello world";
	OutboardTest  t;

	if(args.length == 1)
	    port=new Integer(args[0]).intValue();
	else if(args.length == 2) {
	    port=new Integer(args[0]).intValue();
	    greeting=args[1];
	}

	if(port > 0)
	    t=new OutboardTest(port, greeting);
	else
	    t=new OutboardTest();
	t.Start();
    }

}
