
import java.util.*;
import JavaGroups.*;

public class MultChannels implements Runnable {
    private Channel channels[]=null;
    
    public MultChannels(Vector names) throws Exception {
	channels=new Channel[names.size()];
	for(int i=0; i < names.size(); i++) {
	    System.out.print("Creating channel " + names.elementAt(i) + " ");
	    channels[i]=new EnsChannel((String)names.elementAt(i), null);
	    System.out.println("Done");
	}

	for(int i=0; i < channels.length; i++)
	    channels[i].Connect(1000);

	new Thread(this).start();
    }


    public void Start() throws Exception {
	while(true) {
	    System.out.println("Casting message");
	    for(int i=0; i < channels.length; i++)
		channels[i].Cast(new String("Hello world").getBytes());
	    Thread.currentThread().sleep(1000);
	}
    }


    public void run() {
	Message msg;
	while(true) {
	    try {
		for(int i=0; i < channels.length; i++) {
		    msg=channels[i].Receive(50);
		    if(msg != null)
			System.out.println("Received msg on channel " + 
					   channels[i].GetName() + ": " + msg);
		}
	    }
	    catch(NotConnected conn) {
		break;
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }




    public static void main(String args[]) {
	MultChannels channel;
	Vector names=new Vector();

	if(args.length < 1) {
	    System.err.println("MultChannels <name-1> <name-2> ... <name-n>");
	    return;
	}

	for(int i=0; i < args.length; i++)
	    names.addElement(args[i]);

	try {
	    channel=new MultChannels(names);
	    channel.Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }
}
