

import java.util.*;
import JavaGroups.*;
import JavaGroups.Algorithms.*;



public class GroupRequestTest implements RequestHandler, Runnable {
    String                mode;
    Channel               channel;
    String                grp="DemoGrp";
    GroupRequest          command=null;
    Message               msg, rsp;
    boolean               rc;
    Thread                thread=null;
    RequestCorrelator     corr=null;




    public GroupRequestTest(String mode) {
	this.mode=mode;
    }


    public void Start() throws Exception {
	View     v=null;
	Vector   members=null, suspects=new Vector();

	channel=new JChannel("UDP:FD:MACK:GMS");
	channel.Connect(grp);
	corr=new RequestCorrelator(channel, this);


	if(mode.equals("sender")) {	    
	    v=Util.PeekViews(channel, 2, 3000);
	    if(v == null) {
		System.err.println("View is null !");
		return;
	    }
	    members=(Vector)v.GetMembers().clone();
	}


	thread=new Thread(this);
	thread.start();


	if(mode.equals("sender")) {
	    System.out.println("Starting as sender");
	    msg=new Message(null, null, "Hello world");
	    command=new GroupRequest(msg, corr, members, suspects, GroupRequest.GET_ALL);



	    for(int j=0; j < 20; j++) {
	    

		rc=command.Execute();
		System.out.println("rc=" + rc + ", results are: ");
		Object[] results=command.GetResults();
		
		try {
		    System.out.println("\n");
		    for(int i=0; i < results.length; i++)
			System.out.println(members.elementAt(i) + ": " + results[i]);
		    if(suspects.size() > 0)
			System.out.println("Suspected members were " + suspects);
		    System.out.println("\n");
		}
		catch(ArrayIndexOutOfBoundsException bounds) {
		    System.err.println("+++: " + bounds);
		}



	    }
	    
	    

	    Stop();
	    corr.Stop();
	    return;
	}

	if(mode.equals("receiver")) {
	    System.out.println("Starting as receiver");
	    while(true)
		Thread.currentThread().sleep(20000);
	}

	return;
    }





    public void Stop() {
	try {
	    if(channel != null) {
		channel.Disconnect();
		channel.Close();
		channel=null;
	    }
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }



    public void run() {
	Object o;


	while(true) {
	    try {		
		o=channel.Receive(0);
		if(o == null)
		    continue;

		if(o instanceof Message)
		    corr.Receive((Message)o);
		else if(o instanceof SuspectEvent)
		    corr.Suspect(((SuspectEvent)o).GetMember());
	    }
	    catch(Exception e) {
		//System.err.println(e);
		break;
	    }
	}
    }





    /* Interface RequestHandler */
    public Object Handle(Message msg) {
	Message  rsp;
	long     sleep_time=(long)(Math.random() * 1000);
	
	try {
	    System.out.println("Handle(" + channel.GetLocalAddress() + 
			       "): delaying response for " + sleep_time + "ms");
	    // Thread.currentThread().sleep(sleep_time);
	    // Thread.currentThread().sleep(5000);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	return "The date is " + new Date();
    }








    public static void main(String[] args) {
	GroupRequestTest test=null;
	if(args.length != 1) {
	    System.err.println("GroupRequestTest <'sender' | 'receiver'>");
	    return;
	}
	try {
	    test=new GroupRequestTest(args[0]);
	    test.Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	finally {
	    if(test != null)
		test.Stop();
	}
    }

}
