
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import JavaGroups.*;


class StateExchangeImpl {
    public void SaveState(Object host_obj) {
	
    }
    public Object GetState(Object host_obj) {
	return null;
    }
    public void SetState(Object host_obj, Object new_state) {
	
    }
}




/**
 * Application shows virtual synchrony. A thread in each process randomly chooses square
 * and computes a random color (red/green/blue tuple) for it. It then multicasts the
 * square's location (x,y) and new color to all members of the group. When the message is
 * received (method call SetColor), the corresponding square is set to the new color and
 * repainted.<p>
 * Note that a process must not update its local grid before or after multicasting the update as
 * this could lead to inconsistencies ! Therefore, the Grid demo requires loopback to be
 * enabled, i.e. multicasts to a groups always have to also be received by its sender !
 */

public class GridStateTransferPull extends Frame implements WindowListener, ActionListener, 
					   MembershipListener, Runnable {




    private Dispatcher             dispatcher;
    private Panel                  main_panel, button_panel, bottom_panel;
    private Button                 start_button, stop_button, check_button;
    private Label                  checksum_label=new Label("Checksum: ");
    private final Font             default_font=new Font("Helvetica",Font.PLAIN,12);
    private String                 groupname="GridStateTransferPullGroup";
    private boolean                started=false;
    private int                    NUM=4;
    private ColorComp[][]          grid;
    private ColorComp[][]          grid_copy;
    private Thread                 mythread;
    private Random                 random=new Random(System.currentTimeMillis());
    private boolean                state_set=false;
    private int                    sleeptime=100;  // ms
    private Vector                 my_view;
    private Object                 my_addr;
    private OutputStream           log=null;
    private Vector                 replay_queue=new Vector();
    private Integer                update_mutex=new Integer(0);


    class QueueItem {
	int x=0, y=0;
	Color col;

	QueueItem(int x, int y, Color col) {this.x=x; this.y=y; this.col=col;}

	public String toString() {
	    return "(" + x + "," + y + " [" + col + "])";
	}
    }


 
    public GridStateTransferPull(ChannelFactory factory, String properties, int num, 
			     int sleeptime, String log) {
	NUM=num;
	this.sleeptime=sleeptime;
	grid=new ColorComp[NUM][NUM];    
	main_panel=new Panel();
	main_panel.setLayout(new GridLayout(NUM, NUM));
	button_panel=new Panel();
	bottom_panel=new Panel();
	bottom_panel.setLayout(new BorderLayout());
	start_button=new Button("Start");
	start_button.setFont(default_font);
	start_button.addActionListener(this);
	
	stop_button=new Button("Stop");
	stop_button.setFont(default_font);
	stop_button.addActionListener(this);
	
	check_button=new Button("Checksum");
	check_button.setFont(default_font);
	check_button.addActionListener(this);

	button_panel.add("South", start_button);
	button_panel.add("South", stop_button);
	button_panel.add("South", check_button);
	
	bottom_panel.add("Center", checksum_label);
	bottom_panel.add("South", button_panel);
	checksum_label.setFont(default_font);

	setLayout(new BorderLayout());
	add("Center", main_panel);
	add("South",  bottom_panel);
	SetStarted(false);
		
	try {
	    if(log != null)
		this.log=new FileOutputStream(log);
	    dispatcher=new Dispatcher(factory, properties);
	    dispatcher.SetMethodLookup(new MethodLookupClos());
	    dispatcher.SetMembershipListener(groupname, this);
	    dispatcher.Join(groupname, this);
	    my_addr=dispatcher.GetAddress(groupname);
	    GetInitialState();
	}
	catch(Exception e) {
	    System.err.println(e);
	}

	setSize(300,350);
	addWindowListener(this);
	setVisible(true);
	setTitle("Color Grid");
	setBackground(Color.white);
    }

    
    private void Log(String msg) {
	if(log != null) {
	    try {
		log.write(msg.getBytes());
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }



    void GetInitialState() {
	Vector        members;
	Object        coord;
	ColorComp[][] state=null;
	int           index=0;
	int           num_members=0, num_tries=0;


	for(int x=0; x < NUM; x++)
	    for(int y=0; y < NUM; y++) {
		grid[x][y]=new ColorComp(Color.blue);
		main_panel.add(grid[x][y]);
	    }

	System.out.println("Getting initial state at " + System.currentTimeMillis());


	// If more than 1 member (that's me !), get state from the first member
	// Do it as long as there are members
	
	while((members=dispatcher.GetMembers(groupname)) != null && members.size() > 1) {
	    // System.out.println("Members are: " + members);
	    coord=members.elementAt(index);
	    // System.out.println("Coordinator is " + coord + "(index=" + index + ")");

	    if(coord.equals(my_addr)) {
		// System.err.println("GetInitialState(): coordinator is me !");
		index=(index+1) % members.size();  // try next member
		continue;
	    }
	    try {
		state=(ColorComp[][])dispatcher.Send(groupname, coord, "GetState",
						     false, 2000);
	    }
	    catch(Exception e) {
		System.err.println(e);
		continue;
	    }
	    if(state == null) {
		System.err.println("Call to get state from " + coord + " timed out, retrying");
		continue;
	    }
	    else
		break;
	}
	
	// Here we have the state. It may also be null if no other members in the group !	
	if(state != null) {
	    QueueItem item;
	    synchronized(update_mutex) {  // no interfering with SetColor !
		synchronized(grid) {
		    System.out.println("Successfully got state (checksum=" + GetChecksum(state));
		    SetState(state);
		    for(int i=0; i < replay_queue.size(); i++) {
			item=(QueueItem)replay_queue.elementAt(i);
			System.out.print("REPLAY: (" + item.x + "," + item.y + " [" +
					 item.col + "])\n");
			grid[item.x][item.y].SetColor(item.col);
		    }
		    replay_queue.removeAllElements();
		    state_set=true;
		}
	    }
	}
	else {
	    System.out.println("No state available at " + System.currentTimeMillis());

	}
	state_set=true;
	ComputeChecksum();
    }



    public void ViewAccepted(Vector new_view) {
	synchronized(update_mutex) {
	    System.out.println("New view: " + new_view);
	    
	    if(my_view == null) {     // || new_view.size() > my_view.size()) {
		if(new_view.size() > 1) {
		    CopyState();
		    System.out.println("Saving my state, checksum=" + GetChecksum(grid_copy) +
				       "at " + System.currentTimeMillis());
		}
	    }
	    else {
		if(new_view.size() > my_view.size()) {
		    CopyState();
		    System.out.println("Saving my state, checksum=" + GetChecksum(grid_copy) + 
				       "at " + System.currentTimeMillis());
		}
	    }
	    my_view=new_view;
	}
    }


    void CopyState() {
	synchronized(grid) {
	    grid_copy=new ColorComp[NUM][NUM];
	    try {
		for(int x=0; x < NUM; x++)
		    for(int y=0; y < NUM; y++)
			grid_copy[x][y]=(ColorComp)grid[x][y].clone();
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }


    public Object GetState() {return grid_copy;}


    public void SetState(ColorComp[][] new_grid) {
	synchronized(grid) {
	    System.out.println("Setting grid");

	    try {
		for(int a=0; a < grid.length; a++)
		    for(int b=0; b < grid[a].length; b++)
			grid[a][b].SetColor(new_grid[a][b].GetColor());
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }



    private Color SelectColor() {
	int red=(Math.abs(random.nextInt()) % 255);
	int green=(Math.abs(random.nextInt()) % 255);
	int blue=(Math.abs(random.nextInt()) % 255);
	return new Color(red, green, blue);
    }



    public void run() {
	Color new_color;
	Integer x, y;
	Vector args=new Vector();

	while(started) {
	    x=new Integer(Math.abs(random.nextInt() % NUM));
	    y=new Integer(Math.abs(random.nextInt() % NUM));
	    new_color=SelectColor();

	    try {
		synchronized(System.out) {
		    //System.out.print("Sending (" + x + "," + y + ") at " + 
		    //	     System.currentTimeMillis() + "\n");
		    dispatcher.SendGetN(groupname, "SetColor", x, y, new_color, 0, 0);
		}
		Thread.currentThread().sleep(sleeptime);
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }



	


    public static void main(String[] args) {
	ChannelFactory  factory=new JChannelFactory();
	GridStateTransferPull            grid=null;
	String          properties="UDP(mcast=true;loopback=true)", arg, next_arg;
	int             num=4, sleeptime=100;
	String          logfile=null;

	try {
	    for(int i=0; i < args.length; i++) {
		arg=args[i];
		if(arg.equals("-type")) {
		    next_arg=args[++i];
		    if(next_arg.equals("ens")) {
			factory=new EnsChannelFactory();
			properties=null;
			continue;
		    }		
		}
		else if(arg.equals("-help")) {
		    System.out.println("GridStateTransferPull [-type ens] [-num <number>] "+
				       "[-sleep <time in ms>] [-log <filename>]");
		    return;
		}
		else if(arg.equals("-num")) {
		    num=new Integer(args[++i]).intValue();
		    continue;
		}		
		else if(arg.equals("-sleep")) {
		    sleeptime=new Integer(args[++i]).intValue();
		    continue;
		}
		else if(arg.equals("-log")) {
		    logfile=args[++i];
		    continue;
		}
	    }
	}
	catch(Exception e) {
	    System.out.println("GridStateTransferPull [-type ens] [-num <number>] " +
			       "[-sleep <time (in ms)>] [-log <filename>]");
	    return;
	}

	grid=new GridStateTransferPull(factory, properties, num, sleeptime, logfile);
    }





    


    /* --------------- Callbacks --------------- */


    public void SetColor(int x, int y, Color new_color) {
	synchronized(update_mutex) {
	    if(state_set == false) {
		try {
		    replay_queue.addElement(new QueueItem(x, y, new_color));
		}
		catch(Exception e) {
		    System.err.println(e);
		    return;
		}
		System.out.println("QUEUED SetColor: (" + x + "," + y + " [" + new_color.getRed() +
				   "|" + new_color.getGreen() + "|" + new_color.getBlue() +
				   "]) " + System.currentTimeMillis());
		return;
	    }
	    
	    synchronized(grid) {	    
		System.out.println("SetColor: (" + x + "," + y + " [" + new_color.getRed() +
				   "|" + new_color.getGreen() + "|" + new_color.getBlue() +
				   "]) " + System.currentTimeMillis());
		Log("SetColor  " + x + "," + y + " (" + new_color.getRed() + "|" + 
		    new_color.getGreen() + "|" + new_color.getBlue() + ")\n");
		grid[x][y].SetColor(new_color);
	    }
	}
    }


    void StartThread() {
	if(mythread == null) {
	    mythread=new Thread(this);	
	    mythread.start();	
	}
    }

    public void Start() {
	if(started)
	    return;
	SetStarted(true);
	checksum_label.setText("Running");
	StartThread();
    }


    void SetStarted(boolean flag) {
	started=flag;
	if(started) {
	    stop_button.setEnabled(true);
	    start_button.setEnabled(false);
	}
	else {
	    stop_button.setEnabled(false);
	    start_button.setEnabled(true);
	}
    }

    
    void StopThread() {
	if(mythread != null) {
	    try {
		mythread.join();
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	    mythread.stop();
	    mythread=null;
	}	    

    }

    public void Stop() {
	if(started) {
	    SetStarted(false);
	    StopThread();
	    try {
		dispatcher.SendGetN(groupname, "Stop", 0, 0);
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
	/* Give other threads a chance to finish. If we compute the checksum and still
	   receive updates from other threads that haven't finished processing, our checksum
	   will not reflect the current grid ! A better implementation would use acks to
	   make sure all threads have ended ... */
	try {
	    Thread.currentThread().sleep(500);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
	ComputeChecksum();
    }


    long GetChecksum(ColorComp[][] g) {
	long   checksum=0;
	Color  col;
	synchronized(g) {
	    for(int x=0; x < NUM; x++)
		for(int y=0; y < NUM; y++)
		    checksum+=g[x][y].GetChecksum();
	}
	return checksum;
    }

    public void ComputeChecksum() {	
	checksum_label.setText("Checksum: " + GetChecksum(grid));
    }



    public void windowActivated(WindowEvent e) {}
    public void windowClosed(WindowEvent e) {}
    public void windowClosing(WindowEvent e) {
	setVisible(false);
	dispatcher.Leave(groupname, this);
	System.exit(0);
    }
    public void windowDeactivated(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}


    public void actionPerformed(ActionEvent e) {
	String     command=e.getActionCommand();	
	if(command == "Start")
	    Start();
	else if(command == "Stop")
	    Stop();
	else if(command == "Checksum") {
	    ComputeChecksum();
	    System.out.println(dispatcher.GetMembers(groupname));
	}
	else
	    System.out.println("Unknown action");
    }


}

