
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;

import JavaGroups.Ensemble.*;


public class EnsEcho implements Hot_Callbacks {
    private String                 groupname="SyncCallTest";
    private Hot_Ensemble           ensemble=null;
    private Thread                 ens_thread=null;
    private Hot_GroupContext       group_id=null;
    private Hot_JoinOps            options=null;
    private int                    member_size=0;
    private boolean                first=true;



    public EnsEcho() {
	try {
	    ensemble=new Hot_Ensemble();
	    ens_thread=new Thread(ensemble);
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }



    public static void main(String[] args) {
	EnsEcho draw;
	draw=new EnsEcho();
	draw.go();
    }



    public void go() {
	Hot_Error        rc;
	Hot_GroupContext tmp[]=new Hot_GroupContext[1];

	try {
	    ens_thread.start();
	    options=new Hot_JoinOps();
	    options.heartbeat_rate=5000;
	    options.transports="UDP";
	    options.protocol="Top:Heal:Switch:Leave:Inter:Intra:Elect:Merge:" + 
		"Sync:Suspect:Top_appl:Pt2ptw:Pt2pt:Frag:Stable:Mnak:Bottom";
	    options.group_name=groupname;
	    options.params="primary_quorum=2:int;suspect_max_idle=3:int;suspect_sweep=3.000:time";
	    options.conf=this;
	    options.use_properties=true;
	    rc=ensemble.Join(options, tmp);
	    if(rc != null) {
		System.err.println("Error in JOIN: " + rc);
		System.exit(-1);
	    }
	    group_id=tmp[0];
	    System.out.println("Waiting for messages");
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }



    /* --------------- Callbacks --------------- */


    public synchronized void ReceiveCast(Hot_GroupContext gctx, Object env, 
			    Hot_Endpoint origin, Hot_Message msg) {
	Hot_Error rc;
	Hot_Message rsp=new Hot_Message();
	
	rsp.setBytes(new String("This is a response").getBytes());

	rc=ensemble.Send(group_id, origin, rsp, null);
	if(rc != null)
	    System.err.println("Error: " + rc);
	else
	    System.out.println("Sending response to " + origin);
    }


    public void ReceiveSend(Hot_GroupContext gctx, Object env, 
			    Hot_Endpoint origin, Hot_Message msg) {

	System.out.println("ReceiveSend()");
    }


    public void AcceptedView(Hot_GroupContext gctx, Object env, Hot_ViewState viewState) {
	System.out.println("Accepted view");
	if(first) {
	    System.out.println("My address is " + viewState.members[0]);
	    first=false;
	}
    }


    public void Heartbeat(Hot_GroupContext gctx, Object env, int rate) {

    }


    public void Block(Hot_GroupContext gctx, Object env) {
	System.out.println("BLOCK");
    }


    public void Exit(Hot_GroupContext gctx, Object env) {
	System.out.println("Received EXIT msg, exiting...");
	System.exit(0);
    }




}

