
import java.util.*;
import JavaGroups.*;


public class DemuxTest implements Runnable {
    Demux          demux=new Demux();
    Channel        channels[];

    public DemuxTest(Vector names) {
	channels=new Channel[names.size()];
	for(int i=0; i < names.size(); i++) {
	    channels[i]=new EnsChannel((String)names.elementAt(i), null);
	    try {
		channels[i].Connect(1000);
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	    demux.Add(channels[i]);
	}
    }


    public void Start() {
	Transportable tmp;
	new Thread(this).start();
	while(true) {
	    System.out.println("Sending msg");
	    for(int i=0; i < channels.length; i++) {
		tmp=(Transportable)channels[i];
		try {
		    tmp.Send(new Message(null, null, new String("Hello, world").getBytes()));
		}
		catch(Exception e) {
		    System.err.println(e);
		}
	    }
	    try {
		Thread.currentThread().sleep(1000);
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }

    public void run() {
	Message msg;
	while(true) {
	    try {
		msg=demux.Receive(0);
	    }
	    catch(Exception e) {
		System.err.println(e);
		break;
	    }
	    System.out.println("Received msg: " + msg);
	}
    }
    

    public static void main(String args[]) {
	DemuxTest  t;
	Vector     names=new Vector();

	if(args.length < 1) {
	    System.err.println("DemuxTest <name-1> <name-2> ... <name-n>");
	    return;
	}

	for(int i=0; i < args.length; i++)
	    names.addElement(args[i]);	

	try {
	    t=new DemuxTest(names);
	    t.Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }
}
