
import java.util.*;
import JavaGroups.*;

public class ChannelTest implements Runnable {
    private Channel channel=null;
    private Thread  mythread=null;



    public static void active() {
	System.out.println(Thread.activeCount() + " active threads");
	PrintThreads();
    }



    public static void PrintThreads() {
	Thread threads[]=new Thread[Thread.activeCount()];
	int num=Thread.enumerate(threads);
	System.out.println("------- Threads -------");
	for(int i=0; i < threads.length; i++) {
	    System.out.println("#" + i + ": " + threads[i]);
	}
	System.out.println("------- Threads -------\n");
    }



    public void Start() throws Exception {
	channel=new JChannel(null);
	//channel.SetOpt(Channel.VIEW, new Boolean(false));

	channel.Connect("ChannelTestGroup");
	mythread=new Thread(this, "ChannelTestThread");
	mythread.start();
	for(int i=0; i < 10; i++) {
	    System.out.println("Casting msg #" + i);
	    channel.Send(new Message(null, null, new String("This is msg #" + i).getBytes()));
	    Thread.currentThread().sleep(1000);
	}
	channel.Disconnect();
	mythread.stop();
	PrintThreads();
    }


    public void run() {
	Object msg;
	while(true) {
	    try {
		msg=channel.Receive(0); // no timeout

		if(msg instanceof View) {
		    System.out.println("--> NEW VIEW");
		}

		System.out.println("Received " + msg);
	    }
	    catch(ChannelNotConnected conn) {
		break;
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }



    


    public static void main(String args[]) {
	ChannelTest test;
	try {
	    test=new ChannelTest();
	    test.Start();
	}
	catch(Exception e) {
	    System.err.println(e);
	}
    }
   
}
