package JavaGroups;

import java.util.*;

/**
 * Sends a synchronous message call to a remote process and returns the response message.
 * If the remote process cannot be reached, one or more fallback objects will be tried in
 * succession until there is a response.
 */
public class RepeatedUnicast {

    public class NoMembersLeft extends Exception {
	public NoMembersLeft(String msg) {super(msg);}
    }


    protected Vector         targets=new Vector();
    protected Transport      transport=null;


    public RepeatedUnicast(Transport transport, Vector targs) {
	this.transport=transport;
	for(int i=0; i < targs.size(); i++)
	    targets.addElement(targs.elementAt(i));
    }



    /**
     * Send a message to the first member of <code>targets</code>. If there is no response within
     * <code>timeout</code> milliseconds, remove the first member and try the next member and 
     * so on. Throw an exception if no more members are left.
     */
    public Message Send(Message msg, long timeout) throws NoMembersLeft {
	Message  retval=null;
	Object   current_dest;
	SyncCall call;
	
	while(targets.size() > 0) {
	    current_dest=targets.elementAt(0);

	    try {
		call=new SyncCall(transport);
		retval=call.Send(current_dest, msg.GetBuffer(), false, timeout);
		return retval;
	    }
	    catch(Timeout tex) {
		targets.removeElement(current_dest);
		continue;
	    }
	    catch(Exception e) {
		System.err.println("RepeatedUnicast.Send(): " + e);
		targets.removeElement(current_dest);
		continue;
	    }
	}
	throw new NoMembersLeft("RepeatedUnicast.Send(): no more targets left");
    }


    /**
     * Send a methos call to the first member of <code>targets</code>. 
     * If there is no response within <code>timeout</code> milliseconds, remove the 
     * first member and try the next member and so on. 
     * Throw an exception if no more members are left.
     */
    public Object SendMethod(RemoteMethodCall method, long timeout) throws NoMembersLeft {
	Object   retval=null, current_dest;
	
	while(targets.size() > 0) {
	    current_dest=targets.elementAt(0);

	    try {
		Util.Print("RepeatedUnicast.SendMethod(): trying " + current_dest);
		retval=method.Send(current_dest, false, timeout);
		return retval;
	    }
	    catch(Timeout tex) {
		Util.Print("RepeatUnicast: request timed out (timeout=" + timeout + ")");
		targets.removeElement(current_dest);
		continue;
	    }
	    catch(Exception e) {
		System.err.println("RepeatedUnicast.SendMethod(): " + e);
		targets.removeElement(current_dest);
		continue;
	    }
	}
	throw new NoMembersLeft("RepeatedUnicast.SendMethod(): no more targets left");
    }



}

