package JavaGroups;

import java.util.*;


/**
 * Allows a client of <em>Channel</em> to be notified when messages have been received
 * instead of having to actively poll the channel for new messages. Typically used in the
 * client role (Receive()). As this class does not implement interface 
 * <code>Transport</code>, but <b>uses</b> it for receiving messages, an underlying object
 * has to be used to send messages (e.g. the channel on which an object of this class relies).
 */
public class PullPushAdapter implements Runnable {
    protected Transport           transport;
    protected MessageListener     listener=null;
    protected MembershipListener  membership_listener=null;
    protected Thread              receiver_thread=null;
    
    
    public PullPushAdapter(Transport t) {
	transport=t;
	Start();
    }
    
    public PullPushAdapter(Transport t, MessageListener l) {
	transport=t;
	SetListener(l);
	Start();
    }


    public PullPushAdapter(Transport t, MembershipListener ml) {
	transport=t;
	SetMembershipListener(ml);
	Start();
    }


    public PullPushAdapter(Transport t, MessageListener l, MembershipListener ml) {
	transport=t;
	SetListener(l);
	SetMembershipListener(ml);
	Start();
    }



    public void Start() {
	receiver_thread=new Thread(this, "PullPushAdapterThread");
	receiver_thread.start();
    }

    public void Stop() {
	if(receiver_thread != null) {
	    receiver_thread.stop();
	    receiver_thread=null;
	}
    }
    
    public void SetListener(MessageListener l) {
	listener=l;
    }


    public void SetMembershipListener(MembershipListener ml) {
	membership_listener=ml;
    }
    

    /**
     * Reentrant run(): message reception is serialized, then the listener is notified of the 
     * message reception
     */
    public void run() {
	Object           obj;
	MessageListener  l;

	while(true) {
	    try {
		obj=transport.Receive(0);
		if(obj == null)
		    continue;
		if(obj instanceof Message && listener != null)
		    listener.Receive((Message)obj);		
		else if(obj instanceof View && membership_listener != null)
		    membership_listener.ViewAccepted((View)obj);
		else if(obj instanceof BlockEvent && membership_listener != null)
		    membership_listener.Block();
	    }
	    catch(ChannelNotConnected conn) {
		System.err.println(conn);
		break;
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
    }

}
