package JavaGroups;

import java.util.*;

public class Promise {

    class MyThread extends Thread {
	byte[]   msg;
	int      expected_responses=0;

	MyThread(byte[] msg) {
	    this.msg=msg;
	}

	MyThread(byte[] msg, int expected_responses) {
	    this.msg=msg;
	    this.expected_responses=expected_responses;
	}

	public void run() {
	    SyncCall sync_call=new SyncCall(channel);
	    done=false;
	    if(expected_responses == 0)
		expected_responses=channel.GetNumMembers() -1;
	    try {
		responses=sync_call.SendGetN(msg, expected_responses, 0);
	    done=true;
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }

	}
    }




    private Channel        channel;
    private Thread         mythread=null;
    private Vector         responses;
    private boolean        done=false;


    public Promise(Channel ch) {
	channel=ch;
    }


    public void SendGetAll(byte[] msg) {
	int expected_responses=channel.GetNumMembers() -1;
	if(expected_responses <= 0) {
	    System.err.println("Promise.SendGetAll(): expected_responses is 0 !");
	    return;
	}
	if(mythread != null)
	    mythread.stop();
	mythread=new MyThread(msg);
	mythread.start();
    }


    public void SendGetN(byte[] msg, int expected_responses) {
	if(mythread != null)
	    mythread.stop();
	mythread=new MyThread(msg, expected_responses);
	mythread.start();
    }
    


    public int     NumResponses() {return responses != null? responses.size() : 0;}
    public boolean Done()         {return done;}
    public void    Stop() {
	if(mythread != null) {
	    mythread.stop();
	    mythread=null;
	}
    }
    
}
