package JavaGroups.JavaStack.Protocols;

import java.io.*;

public class Pt2ptHeader implements Serializable {
    public static final int SYN=1;        // SYN request
    public static final int ACK=2;        // acknowledgement of SYN
    public static final int ACK_SYN=3;    // acknowledgement of SYN, plus SYN request
    public static final int DATA=4;       // data
    public static final int DATA_ACK=5;   // acknowledgement of DATA
    public static final int NAK=6;        // negative acknowledgement

    public boolean handle=true;           // handle or pass up ?
    public int     type=0;
    public long    syn_seq=0;             // seq_no in SYN request
    public long    ack_seq=0;             // seq_no in ACK response


    public Pt2ptHeader() {}

    public Pt2ptHeader(int type) {
	this.type=type;
    }


    public Pt2ptHeader(int type, long seq) {
	this.type=type;
	switch(type) {
	case SYN:
	    syn_seq=seq;
	    break;
	case ACK:
	    ack_seq=seq;
	    break;
	case DATA:
	    syn_seq=seq;
	case DATA_ACK:
	    ack_seq=seq;
	}
    }


    public Pt2ptHeader(int type, long ack_no, long seq_no) {
	this.type=type;
	syn_seq=seq_no;
	ack_seq=ack_no;
    }



    public String toString() {
	StringBuffer ret=new StringBuffer();
	ret.append("[PT2PT: " + Type2Str(type));
	switch(type) {
	case SYN:
	case DATA:
	    ret.append("(" + syn_seq + ")");
	    break;
	case ACK:
	case DATA_ACK:
	    ret.append("(" + ack_seq + ")");
	    break;
	case ACK_SYN:
	    ret.append("(" + ack_seq + ", " + syn_seq + ")");
	    break;
	}
	ret.append("]");
	return ret.toString();
    }

    public static String Type2Str(int t) {
	switch(t) {
	case SYN:
	    return "SYN";
	case ACK:
	    return "ACK";
	case ACK_SYN:
	    return "ACK_SYN";
	case DATA:
	    return "DATA";
	case DATA_ACK:
	    return "DATA_ACK";
	case NAK:
	    return "NAK";
	default:
	    return "<undefined>";
	}
    }
}
