package JavaGroups.JavaStack.Protocols;

import java.net.*;
import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;








public class GmsImpl {
    private final             int CLIENT_ROLE=0;
    private final             int SERVER_ROLE=1;
    private int               role=CLIENT_ROLE;
    private ViewId            view_id=null;
    private long              ltime=0;   // Highest view_id.id seen so far
    private Membership        members=new Membership();
    private GMS               host=null;
    private ProtocolStack     stack=null;
    private boolean           connecting=true, join_received=false, leaving=false;
    private Address           local_addr=null;


    public long GetLtime() {return ltime;}


    private Object SendLeave(Object dest, Object addr, long timeout) throws Exception {
	RemoteMethodCall call=new RemoteMethodCall(host, "Leave", addr);
	return call.Send(dest, false, timeout);
    }



    private synchronized void CastViewChange() throws Exception {
	RemoteMethodCall  call;
	ViewId            tmp_id;

	if(members == null || members.size() == 0)
	    return;

	if(!local_addr.equals(view_id.GetCoordAddress()))
	    view_id.SetCoordAddress(local_addr);
	
	tmp_id=view_id.Copy();
	tmp_id.SetId(++ltime);
	
	call=new RemoteMethodCall(host, "ViewChange", tmp_id, members.GetMembers());
	System.out.println("Casting VIEW_CHANGE(" + tmp_id + ", ltime=" + ltime + ")");
	call.SendGetN(0, 0);
    }





    /** Public because called by GMS */
    public void CastMerge(Vector new_mbrs, Vector suspects) throws Exception {
	if(new_mbrs == null) new_mbrs=new Vector();  // make sure the correct method is looked up
	if(suspects == null) suspects=new Vector();  // make sure the correct method is looked up

	RemoteMethodCall call=new RemoteMethodCall(host, "Merge", (Object)new_mbrs, (Object)suspects,
						   new Long(ltime));
	call.SendGetN(0, 0);
    }

    public void CastSuspect(Object suspected) throws Exception {
	RemoteMethodCall call=new RemoteMethodCall(host, "Suspect", suspected);
	call.SendGetN(0, 0);
    }


    /** Called by GMS as soon as address is known */
    public void SetLocalAddress(Address addr) {local_addr=addr;}


    // Check whether local_addr is the first member of the view
    public boolean IsCoordinator() {
	Object first;
	synchronized(members) {
	    first=members.size() > 0 ? members.elementAt(0) : null;
	    return first == null ? true : local_addr.equals(first);
	}       	    
    }

    public Address DetermineCoordinator() {
	return members != null && members.size() > 0 ? (Address)members.elementAt(0) : null;
    }




    private void RemoveMyself(Vector mems) {
	PingRsp mbr;
	for(int i=0; i < mems.size(); i++) {
	    mbr=(PingRsp)mems.elementAt(i);
	    if(mbr == null)
		continue;

	    if(mbr.own_addr == null) {
		mems.removeElement(mbr);
		continue;
	    }

	    if(local_addr.equals(mbr.own_addr)) {
		mems.removeElement(mbr);
		return;
	    }
	}
    }


    private Object FindCoord(Vector mbrs) {
	PingRsp mbr;
	if(mbrs == null || mbrs.size() < 1)
	    return null;

	for(int i=0; i < mbrs.size(); i++) {
	    mbr=(PingRsp)mbrs.elementAt(i);
	    if(mbr.coord_addr != null)
		return mbr.coord_addr;
	}
	return null;
    }




    /** Returns true if local_addr is member of mbrs, else false */
    private boolean CheckSelfInclusion(Vector mbrs) {
	Object mbr;
	if(mbrs == null)
	    return false;
	for(int i=0; i < mbrs.size(); i++) {
	    mbr=mbrs.elementAt(i);
	    if(mbr != null && local_addr.equals(mbr))
		return true;
	}
	return false;
    }


    private View MakeView(Vector mbrs) {
	Object  coord=null;
	long    id=0;

	if(view_id != null) {
	    coord=view_id.GetCoordAddress();
	    id=view_id.GetId();
	}
	return new View(coord, id, mbrs);
    }



    /*-----------------------------------------------------------------------------*/
    /*----------------------------- Public members --------------------------------*/
    /*-----------------------------------------------------------------------------*/


    public GmsImpl(GMS host) {
	this.host=host;
	if(host != null)
	    stack=host.GetProtocolStack();
	// local_addr=GetLocalAddress();
    }


    public ViewId  GetViewId()  {return view_id;}


    public PingRsp Ping() {
	return role == CLIENT_ROLE ? new PingRsp(local_addr, local_addr) : 
        	                     new PingRsp(local_addr, DetermineCoordinator());
    }

    



    /**
     * Called by non-member (client) to join a group. Will result in a unicast Join message
     * to be sent to the coordinator.
     */
    public void StartJoin(Vector initial_mbrs) {
	RemoteMethodCall  call;
	RepeatedUnicast   rep_cast;
	Event             view_event;
	Vector            tmp;
	Object            coord;
	Boolean           retval;

	leaving=false;

	if(stack == null)
	    stack=host.GetProtocolStack();	

	
	Util.Print("\n----------------------------------------------------------\n" +
		   "GmsImpl.StartJoin(): my address is " + local_addr + 
		   "\n----------------------------------------------------------");


	// System.out.println("StartJoin(): initial members are " + initial_mbrs);

	view_id=new ViewId(local_addr);
	members.Add(local_addr);

	view_event=new Event(Event.VIEW_CHANGE, MakeView(members.GetMembers()));
	if(host != null) {
	    host.PassUp(view_event);
	    host.PassDown(view_event); // needed e.g. by failure detector or UDP
	}


	while(true) {

	    if(initial_mbrs.size() == 0) {  // Assume I'm first member in group
		//Util.Print("GmsImpl.StartJoin(): found no members; I assume I'm the first member.");
		break;
	    }
	    else {
		RemoveMyself(initial_mbrs);
		// Util.Print("GmsImpl.StartJoin(): found members " + initial_mbrs);
		coord=FindCoord(initial_mbrs);
		if(coord != null) {  // coordinator among the respondents
		    call=new RemoteMethodCall(host, "Join", local_addr);
		    
		    try {
			retval=(Boolean)call.Send(coord, false, 3000);
			if(retval != null && retval.booleanValue() == true) {
			    System.out.println("Join request sent to " + coord + " succeeded");
			    break;
			}
			else { // coord is not the coord anymore (coord change after FindCoord)
			    System.err.println("Join request sent to " + coord + " failed, " +
					       "continuing");
			    
			    // continue;
			    break;  // ?????????????
			}
		    }
		    catch(Timeout tex) {
			try {

			    break; // ?????????

			    // CastSuspect(coord);  // will remove coord from membership
			}
			catch(Exception e) {
			    System.err.println("GmsImpl.Join() " + e);
			}
		    }
		    catch(Exception e) {
			System.err.println("GmsImpl.StartJoin(): " + e);
			break;
		    }
		}
		else  // coordinator not among the respondents, first mbr of grp
		    continue; // break; ??
	    }	    
	}
	//Util.Print("GmsImpl.StartJoin(): done");

	if(join_received) {
	    try {
		CastMerge(members.GetMembers(), null);
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }
	}
	role=SERVER_ROLE;
    }






    
    /**
     * Will always be called via unicast message ! Should NOT be called via mcast, because
     * every non-coordinator would try to forward to the coord, resulting in a broadcast storm !
     */
    public boolean Join(Address new_member) {
	Boolean  retval=null;
	Object   coord;

	if(role == CLIENT_ROLE) {	    
	    if(local_addr.equals(new_member))
		return false;
	    members.Add(new_member);
	    join_received=true;
	    // return false;
	    return true; // ??????????????????????????/
	}

	if(IsCoordinator()) {  // Coordinator
	    if(local_addr.equals(new_member)) {
		System.err.println("GmsImpl.Join(): coordinator already joined !");
		return true;
	    }

	    try {
		members.Add(new_member);
		// Set temporary membership in UDP layer so that multicast gets sent to
		// the correct destinations
		Event view_event=new Event(Event.VIEW_CHANGE, MakeView(members.GetMembers()));
 		if(host != null)
 		    host.PassDown(view_event); // needed e.g. by failure detector or UDP

		CastViewChange();
		return true;
	    }
	    catch(Exception e) {
		System.err.println("GmsImpl.Join(): " + e);
		return false;
	    }
	}
	else       // Not Coordinator
	    return false;
    }




    /**
     * Called by members that want to leave group. Will in turn send a unicast Leave message to
     * the coordinator.
     */
    public void StartLeave(Address mbr) {
	Address   coord;
	Boolean   retval;
	int       numtries=5;

	if(mbr.equals(local_addr))
	    leaving=true;

	while((coord=DetermineCoordinator()) != null && numtries-- > 0) {

	    if(local_addr.equals(coord)) {
		Leave(mbr);
		break;
	    }
		
	    try {
		retval=(Boolean)SendLeave(coord, mbr, 3000);
		if(retval != null && retval.booleanValue() == true) {
		    System.out.println("Leave request sent to " + coord + " succeeded");
		    break;
		}
		else {
		    members.Remove(coord);
		    System.out.println("Leave request sent to " + coord + " failed, continuing...");
		    continue;
		}
	    }
	    catch(Timeout tex) {
		try {
		    // members.Remove(mbr);
		    CastSuspect(coord);  // will remove coord from membership
 		}
 		catch(Exception e) {
 		    System.err.println("GmsImpl.StartLeave() " + e);
 		}

	    }
	    catch(Exception e) {
		System.err.println("GmsImpl.StartLeave(): " + e);
	    }			      
	}
    }




    /**
     * Will always be called via unicast message ! Should NOT be called via mcast, because
     * every non-coordinator would try to forward to the coord, resulting in a broadcast storm !
     */
    public boolean Leave(Address addr) {
	Boolean  retval=null;
	Object   coord;

	if(role == CLIENT_ROLE) {  // should never happen !
	    members.Remove(addr);
	    return false;
	}

	if(IsCoordinator()) {
	    if(local_addr.equals(addr))
		System.err.println("GmsImpl.Leave(): coordinator itself is leaving");


	    if(!members.Contains(addr)) {
		System.err.println("GmsImpl.Leave(" + addr + "): member already left !");
		return true;
	    }


	    members.Remove(addr);

	    try {
		// Set temporary membership in UDP layer (and others !) so that multicast gets sent to
		// the correct destinations
		//Event view_event=new Event(Event.VIEW_CHANGE, MakeView(members.GetMembers()));  // +++
 		//if(host != null) // +++
 		//    host.PassDown(view_event); // needed e.g. by UDP, MACK // +++

		if(members.size() > 0)
		    CastViewChange();
		return true;
	    }
	    catch(Exception e) {
		System.err.println("GmsImpl.Leave(): " + e);
		return false;
	    }
	}
	else
	    return false;	    
    }





    public synchronized void ViewChange(ViewId new_view, Vector mems) {
	Object  coord;
	int     rc;

	ltime=Math.max(new_view.GetId(), ltime) + 1;  // compute Lamport's logical time
	// System.out.println("ltime=" + ltime + ", new_view=" + new_view);


	System.out.println("==> Received VIEW_CHANGE(" + new_view + ")");


	/* Check for self-inclusion: if I'm not part of the new membership, I just discard it */
	if(CheckSelfInclusion(mems) == false && leaving == false) {
	    System.err.println("GmsImpl.ViewChange(): I'm not member of " + mems + ", discarding");
	    return;
	}

	if(leaving)
	    return;


	if(view_id != null && new_view != null) {
	    rc=new_view.Compare(view_id);  // rc should always be a positive number
	    
	    // System.out.println("view_id: " + view_id + ", new_view: " + new_view + ", rc: " + rc);
	    
	    if(rc <= 0) {  // don't accept view id lower than our own
		Util.Print("**** ViewChange, rc is " + rc + ": received view smaller than current " +
			   "view; discarding it ! ***");
		Util.Print("view_id: " + view_id + "\nnew_view: " + new_view);
		// Util.DumpStack(false);
		return;
	    }
	}

	if(new_view.GetCoordAddress() != null)
	    view_id.SetCoordAddress(new_view.GetCoordAddress());
	view_id.SetId(ltime);

	


	

	if(mems.size() == 0) {
	    Util.Print("GmsImpl.ViewChange(): size of members is 0 !");
	    return;
	}

	if(role == CLIENT_ROLE) {
	    members.Set(mems);
	}
	else {

	    coord=DetermineCoordinator();	    
	    
	    if(IsCoordinator()) {  // coordinator

		/* If I'm the coordinator (I think !), and receive a ViewChange with someone else
		   as coordinator, I cast a Merge request */
		if(!local_addr.equals(new_view.GetCoordAddress())) {
		    members.Merge(mems, null);
		    try {
			CastMerge(members.GetMembers(), null);
		    }
		    catch(Exception e) {
			System.err.println(e);
		    }
		}
		else {
		    members.Set(mems);
		}
	    }

	    else {                                           // not coordinator
		members.Set(mems);
	    }

	}

	// Send VIEW_CHANGE event up and down the stack:

	Event view_event=new Event(Event.VIEW_CHANGE, MakeView(mems));
	if(host != null) {
	    host.PassUp(view_event);
	    host.PassDown(view_event); // needed e.g. by failure detector or UDP
	}

	if(connecting)
	    connecting=false;
    }





    public synchronized void Merge(Vector new_mems, Vector suspects, long other_ltime) throws Exception {
	ltime=Math.max(ltime, other_ltime) + 1;
	members.Merge(new_mems, suspects);
	members.Sort();
	if(IsCoordinator() && members.size() > 0) {
	    System.out.println("I'm the new coordinator !");
	    CastViewChange();
	}
    }



    public synchronized void Suspect(Address suspected_mbr) throws Exception {

	if(role == CLIENT_ROLE) {
	    System.out.println("Suspect(" + suspected_mbr + "): am CLIENT, not processing");
	    return;
	}

	System.out.println("GmsImpl.Suspect(" + suspected_mbr + "): members are " + members);

	members.Remove(suspected_mbr);
	if(IsCoordinator() && members.size() > 0)
	    CastViewChange();
    }



}
