package JavaGroups.JavaStack.Protocols;

import java.io.*;
import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;

/**
 * Example of a protocol layer. Contains no real functionality, can be used as a template.
 */

public class EXAMPLE extends Protocol {
    boolean  trace=false;
    Vector   members=null;

    public String  GetName() {return "EXAMPLE";}


    public void SetProperties(Properties props) {
	String     str;

	this.props=props;
	str=props.getProperty("trace");
	if(str != null)
	    trace=new Boolean(str).booleanValue();
    }


    /** Just remove if you don't need to reset any state */
    public void Reset() {}




    public void Up(Event evt) {
	Message msg;

	switch(evt.GetType()) {

	case Event.START:
	    // Start work
	    PassUp(evt);
	    break;

	case Event.MSG:
	    msg=(Message)evt.GetArg();
	    // Do something with the event, e.g. extract the message and remove a header.
	    // Optionally pass up
	    break;

	default:
	    PassUp(evt);            // Pass up to the layer above us
	    break;
	}
    }





    public void Down(Event evt) {
	Message msg;

	switch(evt.GetType()) {
	case Event.STOP:
	    // Stop work
	    PassDown(evt);
	    break;

	case Event.VIEW_CHANGE:
	    Vector tmp;
	    if((tmp=(Vector)((View)evt.GetArg()).GetMembers()) != null)
		members=tmp;
	    PassDown(evt);
	    break;

	case Event.MSG:
	    msg=(Message)evt.GetArg();
	    // Do something with the event, e.g. add a header to the message
	    // Optionally pass down
	    break;
	    
	default:
	    PassDown(evt);          // Pass on to the layer below us
	    break;
	}
    }



}
