package JavaGroups.JavaStack;

import java.net.*;
import java.util.*;

/**
 * Class to keep track of Addresses.
 */
public class Membership {
    private Vector members=new Vector();

    public Membership() {}

    public Membership(Vector initial_members) {
	if(initial_members != null)
	    for(int i=0; i < initial_members.size(); i++)
		members.addElement(initial_members.elementAt(i));
    }

    public synchronized Vector GetMembers() {return members;}
    
    public synchronized void Add(Address new_member) {
	Address tmp;
	for(int i=0; i < members.size(); i++) {
	    tmp=(Address)members.elementAt(i);
	    if(new_member.equals(tmp))
		return;
	}
	members.addElement(new_member);	    
    }


    public synchronized void Remove(Address old_member) {
	Address tmp;
	for(int i=0; i < members.size(); i++) {
	    tmp=(Address)members.elementAt(i);
	    if(old_member.equals(tmp)) {
		members.removeElement(tmp);
		return;
	    }
	}
    }


    public synchronized void Remove(Vector suspected) {
	Address tmp;
	for(int i=0; i < suspected.size(); i++) {
	    tmp=(Address)suspected.elementAt(i);
	    Remove(tmp);
	}
    }


    public synchronized void Set(Vector mems) {
	members.removeAllElements();
	if(mems == null) return;
	for(int i=0; i < mems.size(); i++)
	    members.addElement(mems.elementAt(i));
    }


    public synchronized void Merge(Vector new_mems, Vector suspects) {
	if(suspects != null && suspects.size() > 0)
	    Remove(suspects);
	if(new_mems != null && new_mems.size() > 0)
	    for(int i=0; i < new_mems.size(); i++)
		Add((Address)new_mems.elementAt(i));
    }


    public synchronized boolean Contains(Address member) {
	Address tmp;

	if(member == null) return false;
	for(int i=0; i < members.size(); i++) {
	    tmp=(Address)members.elementAt(i);
	    if(tmp.equals(member))
		return true;
	}
	return false;
    }


    /* Simple inefficient bubble sort, but not used very often (only when merging) */
    public synchronized void Sort() {
	Address          a1, a2, tmp;

	for(int j=0; j < members.size(); j++) {
	    for(int i=0; i < members.size()-1; i++) {
		a1=(Address)members.elementAt(i);
		a2=(Address)members.elementAt(i+1);
		if(a1 == null || a2 == null) {
		    System.err.println("Membership.SortMembers(): member's address is null");
		    continue;
		}
		if(a1.Compare(a2) > 0) {
		    tmp=a2;			
		    members.setElementAt(a1, i+1);
		    members.setElementAt(tmp, i);
		}
	    }
	}
    }


    public int size() {return members.size();}

    public Object elementAt(int index) {return members.elementAt(index);}

    public String toString() {
	return members.toString();
    }


    public static void main(String args[]) {
	Membership  m=new Membership();	
	Address     a1, a2, a3, a4, a5;

	try {
	    a1=new Address(InetAddress.getByName("janet"), 1023);
	    a2=new Address(InetAddress.getByName("janet"), 1005);
	    a3=new Address(InetAddress.getByName("janet"), 5500);
	    a4=new Address(InetAddress.getByName("gulag"), 5500);
	    a5=new Address(InetAddress.getByName("bela"),  1500);

	    m.Add(a1); m.Add(a2); m.Add(a3); m.Add(a4); m.Add(a5);

	    System.out.println(m);
	    m.Sort();
	    System.out.println(m);
	}
	catch(Exception e) {
	    System.err.println(e);
	}

    }
    
}
