package JavaGroups;



/**
 * Used for inter-stack and intra-stack communication.
 */
public class Event implements java.io.Serializable {
    public static final int START                     =  1;
    public static final int START_OK                  =  2;
    public static final int STOP                      =  3;
    public static final int STOP_OK                   =  4;
    public static final int MSG                       =  5;
    public static final int CONNECT                   =  6;
    public static final int CONNECT_OK                =  7;    
    public static final int DISCONNECT                =  8;
    public static final int DISCONNECT_OK             =  9;
    public static final int VIEW_CHANGE               = 10;
    public static final int GET_LOCAL_ADDRESS         = 11;
    public static final int SET_LOCAL_ADDRESS         = 12;
    public static final int FLUSH                     = 13;
    public static final int FLUSH_OK                  = 14;
    public static final int SUSPECT                   = 15;
    public static final int BLOCK                     = 16;
    public static final int BLOCK_OK                  = 17;
    public static final int FIND_INITIAL_MBRS         = 18;
    public static final int FIND_INITIAL_MBRS_OK      = 19;
    public static final int MERGE                     = 20;  // arg = Vector of Objects



    private int     type=0;       // type of event
    private Object  arg=null;     // must be serializable if used for inter-stack communication


    public Event(int type) {
	this.type=type;
    }

    public Event(int type, Object arg) {
	this.type=type;
	this.arg=arg;
    }

    public int     GetType()                {return type;}
    public void    SetType(int type)        {this.type=type;}

    public Object  GetArg()                 {return arg;}
    public void    SetArg(Object arg)       {this.arg=arg;}



    public String Type2String(int t) {
	switch(t) {
	case START:
	    return "START";
	case START_OK:
	    return "START_OK";
	case STOP:
	    return "STOP";
	case STOP_OK:
	    return "STOP_OK";
	case MSG:
	    return "MSG";
	case CONNECT:
	    return "CONNECT";
	case CONNECT_OK:
	    return "CONNECT_OK";
	case DISCONNECT:
	    return "DISCONNECT";
	case DISCONNECT_OK:
	    return "DISCONNECT_OK";
	case VIEW_CHANGE:
	    return "VIEW_CHANGE";
	case GET_LOCAL_ADDRESS:
	    return "GET_LOCAL_ADDRESS";
	case SET_LOCAL_ADDRESS:
	    return "SET_LOCAL_ADDRESS";
	case FLUSH:
	    return "FLUSH";
	case FLUSH_OK:
	    return "FLUSH_OK";
	case SUSPECT:
	    return "SUSPECT";
	case BLOCK:
	    return "BLOCK";
	case BLOCK_OK:
	    return "BLOCK_OK";
	case FIND_INITIAL_MBRS:
	    return "FIND_INITIAL_MBRS";
	case FIND_INITIAL_MBRS_OK:
	    return "FIND_INITIAL_MBRS_OK";
	case MERGE:
	    return "MERGE";
	default:
	    return "UNDEFINED";
	}
    }

    public String toString() {
	StringBuffer ret=new StringBuffer();
	ret.append("Event[type=" + Type2String(type) + ", arg=" + arg + "]");
	return ret.toString();
    }
}

