package JavaGroups;

import java.util.*;


/**
 * A Demultiplexer allows to receive messages from a number of channels (similar to the Unix
 * SELECT system call). It assigns a separate thread for each channel it has to listen on and
 * adds received messages to a single message queue. Method <em>Receive</em> removes messages
 * from this queue.
 */
public class Demux implements Transportable {

    class ChannelReader implements Runnable {
	private Transportable t;

	ChannelReader(Transportable t) {
	    this.t=t;
	    new Thread(this).start();
	}

	public void run() {
	    Message msg;
	    while(true) {
		try {
		    msg=t.Receive(0);
		    mq.Add(msg);
		}
		catch(NotConnected conn) {
		    Remove(t);
		    break;
		}
		catch(Exception e) {
		    System.err.println(e);
		}
	    }
	}
    }


    protected Vector channels=new Vector();
    protected Queue  mq=new Queue();
    

    public void Add(Transportable t) {
	if(!channels.contains(t)) {
	    channels.addElement(t);
	    new ChannelReader(t);
	}
    }

    public void Remove(Transportable t) {
	channels.removeElement(t);
    }


    public void Send(Message msg) throws NotConnected {
	System.err.println("Demux.Send(): cannot be used with Demux !");
    }

    public Message Receive(long timeout) throws NotConnected {
	try {
	    return (Message)mq.Remove(timeout);
	}
	catch(Exception e) {
	    System.err.println(e);
	    return null;
	}
    }
    
    
}
