package JavaGroups.Algorithms;


/**
 * Interface for state exchange. A class implementing state exchange has to provide bodies
 * for the 3 methods below.
 */
public interface StateExchange {

    /** Save the current state in a copy */
    public void   SaveState();

    /** Return the <em>copy</em> of the saved state. Copy was previously created by SaveState */
    public Object GetState();

    /** Set the current state to be <code>new_state</code> */
    public void   SetState(Object new_state);
}
