package JavaGroups;


import java.util.*;

/**
   Maintains a window of <code>window_size</code> size (should currently be the same as in the
   AckSenderWindow counterpart (we don't yet have dynamically adjusting window sizes). Any message
   is added in order, duplicate messages are discarded. Every message received is ACK'ed (even 
   duplicates). When the window is full, only a message that would remove a message from the window
   is accepted (that is, one whose seq_no is equal to the <code>next_to_remove</code>), all
   others are discarded.<p>
   Messages are removed in order; the first message has to have its seq_no equal to 
   <code>next_to_remove</code> (which will be incremented when a message is removed).
 */
public class AckReceiverWindow {
    int     window_size=100;
    long    next_to_remove=0;
    Vector  msgs=new Vector();



    class Entry {	
	long      seq_no=0;
	Message   msg;
	
	Entry(long seq_no, Message msg) {
	    this.seq_no=seq_no;
	    this.msg=msg;
	}
	
	public String toString() {return "" + seq_no;}
    }




    public AckReceiverWindow(long initial_seq_no) {
	next_to_remove=initial_seq_no;
    }

    public AckReceiverWindow(int window_size, long initial_seq_no) {
	this(initial_seq_no);
	this.window_size=window_size;
    }

    

    public void Add(long seq_no, Message msg) {
	Entry    e;
	boolean  inserted=false;

	synchronized(msgs) {

	    if(seq_no < next_to_remove) {
		System.out.println("AckReceiverWindow.Add(): discarded msg with seq_no=" + seq_no +
				   ": next msg to receive is " + next_to_remove);
		return;
	    }

	    if(seq_no == next_to_remove) {
		if(msgs.size() == 0) {
		    msgs.addElement(new Entry(seq_no, msg));
		    return;
		}
		else {
		    e=(Entry)msgs.firstElement();
		    if(e.seq_no == seq_no) {
			System.err.println("AckReceiverWindow.Add(): element with seq_no=" + seq_no +
					   " is already present, discarding duplicate");
			return;
		    }
		    if(e.seq_no < seq_no) {
			System.err.println("AckReceiverWindow.Add(): seq_no to be added is greater " +
					   "than first element");
		    }
		    else {
			msgs.insertElementAt(new Entry(seq_no, msg), 0);
		    }
		}
	    }
	    else {
		if(msgs.size() >= window_size) {
		    System.err.println("AckReceiverWindow.Add(): window is full, discarding message " +
				       "with seq_no=" + seq_no);
		    return;
		}

		if(seq_no > next_to_remove + window_size) {
		    System.err.println("AckReceiverWindow.Add(): message seq_no (" + seq_no + 
				       ") is greater than first to remove (" + next_to_remove +
				       ") plus window size (" + window_size + ") = " +
				       (next_to_remove + window_size) + "; discarding message");
		    return;
		}

		for(int i=0; i < msgs.size(); i++) {
		    e=(Entry)msgs.elementAt(i);
		    if(e.seq_no == seq_no) {
			System.err.println("AckReceiverWindow.Add(): discarding duplicate (" +
					   seq_no + ")");
			return;
		    }
		    if(e.seq_no < seq_no)
			continue;
		    else {
			msgs.insertElementAt(new Entry(seq_no, msg), i);
			inserted=true;
			break;
		    }
		}
		if(!inserted)
		    msgs.addElement(new Entry(seq_no, msg));
	    }


	    
	}
    }

    /**
       Removes a message whose seq_no is equal to <code>next_to_remove</code>, increments the latter.
       Returns message that was removed, or null, if no message can be removed. Messages are thus
       removed in order.
     */
    public Message Remove() {
	Message retval=null;
	Entry   e;

	synchronized(msgs) {
	    while(msgs.size() > 0) {
		e=(Entry)msgs.firstElement();
		if(e.seq_no == next_to_remove) {
		    retval=e.msg;
		    msgs.removeElementAt(0);
		    break;
		}
		else
		    break;
	    }
	}

	if(retval != null)
	    next_to_remove++;

	return retval;
    }


    public String toString() {
	return msgs.toString();
    }




    public static void main(String[] args) {
	AckReceiverWindow win=new AckReceiverWindow(8, 33);
	Message           m=new Message(), ret;

	win.Add(37, m);
	System.out.println(win);


	ret=win.Remove();
	if(ret == null)
	    System.out.println("Removed nothing, win is " + win);
	else
	    System.out.println("Removed something, win is " + win);
	

	win.Add(35, m);
	System.out.println(win);
	
	win.Add(36, m);
	System.out.println(win);

	ret=win.Remove();
	if(ret == null)
	    System.out.println("Removed nothing, win is " + win);
	else
	    System.out.println("Removed something, win is " + win);


	
	win.Add(33, m);
	System.out.println(win);

	
	win.Add(38, m);
	System.out.println(win);

	ret=win.Remove();
	if(ret == null)
	    System.out.println("Removed nothing, win is " + win);
	else
	    System.out.println("Removed something, win is " + win);
	

	win.Add(35, m);
	System.out.println(win);
	
	win.Add(332, m);
	System.out.println(win);


    }
    
}
