/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups.Protocols;

import JavaGroups.Address;
import JavaGroups.McastAddress;
import JavaGroups.Message;
import JavaGroups.MessageQueue;
import JavaGroups.Protocol;
import JavaGroups.Protocols.UDP;
import JavaGroups.UnicastAddress;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class UdpSenderThread
extends Thread {
    private UDP udp_prot;
    private DatagramPacket packet;
    private DatagramSocket[] sockets;
    private int num_socks = 1;
    private int curr_sock;
    private boolean is_linux = false;
    private final int UDP_MAX_PACKET_SIZE = 8192;

    private void CheckForLinux() {
        String os = System.getProperty("os.name");
        if (os != null && os.equals("Linux")) {
            System.out.println("UdpSenderThread: OS is Linux; using the SENDTO() workaround \n(see ./design/sendto.txt)");
            this.is_linux = true;
        }
    }

    public UdpSenderThread(UDP udp, int num) {
        this.CheckForLinux();
        this.udp_prot = udp;
        if (num <= 0) {
            System.err.println("UdpSenderThread: number of sockets is corrected to 1");
            this.num_socks = 1;
        } else {
            this.num_socks = num;
        }
        try {
            this.sockets = new DatagramSocket[this.num_socks];
            int i = 0;
            while (i < this.num_socks) {
                this.sockets[i] = new DatagramSocket();
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    protected synchronized void SendPacket(Address dest, byte[] buf) throws Exception {
        boolean done = false;
        this.packet = new DatagramPacket(buf, buf.length, dest.GetAddress(), dest.GetPort());
        if (this.packet.getLength() > 8192) {
            System.err.println("UdpSenderThread.Send(): packet size exceeds maximum UDP packet size: " + this.packet.getLength());
        }
        while (!done) {
            try {
                this.sockets[this.curr_sock].send(this.packet);
                if (this.is_linux) {
                    this.sockets[this.curr_sock].close();
                    this.sockets[this.curr_sock] = new DatagramSocket();
                }
                ++this.curr_sock;
                done = true;
            }
            catch (SecurityException sec) {
                System.out.println(sec);
                sec.printStackTrace();
            }
            catch (Exception e) {
                System.err.println("UdpSenderThread: " + e);
            }
            if (this.curr_sock < this.num_socks) continue;
            this.curr_sock = 0;
        }
    }

    public void run() {
        int in_port = this.udp_prot.GetInPort();
        MessageQueue send_queue = this.udp_prot.GetSendQueue();
        while (true) {
            try {
                while (true) {
                    Message msg = send_queue.Remove();
                    Protocol send_prot = this.udp_prot.GetSendProtocol();
                    in_port = this.udp_prot.GetInPort();
                    if (send_prot != null) {
                        send_prot.Send(msg);
                        continue;
                    }
                    Address dest = msg.GetDestinationAddress();
                    Address src_addr = msg.GetSourceAddress();
                    if (src_addr == null) {
                        System.err.println("UdpSenderThread.run(): src address of msg is null !");
                        continue;
                    }
                    src_addr.SetPort(in_port);
                    ByteArrayOutputStream out_stream = new ByteArrayOutputStream(256);
                    ObjectOutputStream out = new ObjectOutputStream(out_stream);
                    out.writeObject(msg);
                    byte[] bytes_to_send = out_stream.toByteArray();
                    if (dest instanceof UnicastAddress || dest instanceof McastAddress) {
                        this.SendPacket(dest, bytes_to_send);
                        continue;
                    }
                    System.err.println("Destination address " + dest + " is not valid !");
                }
            }
            catch (Exception e) {
                System.err.println(e);
                continue;
            }
            break;
        }
    }
}

