/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups;

import JavaGroups.Address;
import JavaGroups.Dispatcher;
import JavaGroups.FailureDetector;
import JavaGroups.FailureDetectorListener;
import JavaGroups.Group;
import JavaGroups.MethodCall;
import JavaGroups.MultipleAddress;
import JavaGroups.OID;
import JavaGroups.RpcMessage;
import JavaGroups.Suspectable;
import JavaGroups.UnicastAddress;
import java.util.Vector;

public class FdImpl
implements FailureDetector,
Runnable {
    private Vector members = new Vector();
    private Vector listeners = new Vector();
    private Vector fd_listeners = new Vector();
    private long interval = 3000L;
    private long timeout = 3000L;
    private Thread coordinator;
    private TimerThread timer;
    private Dispatcher dispatcher;
    private OID my_oid;
    private UnicastAddress my_addr;
    private Group my_group;
    private final String group_name = "FailureDetectors";
    private long last_heartbeat_received;
    private int next_coord;

    private void NotifyFdListeners(MethodCall m) {
        int i = 0;
        while (i < this.fd_listeners.size()) {
            m.Invoke((FailureDetectorListener)this.fd_listeners.elementAt(i));
            ++i;
        }
    }

    public FdImpl(Dispatcher d) {
        this.dispatcher = d;
        this.my_oid = this.dispatcher.Register(this);
        this.my_addr = new UnicastAddress(this.my_oid);
        this.my_addr.SetPort(this.dispatcher.GetTransport().GetInPort());
    }

    public void FdAddFailureDetectorListener(FailureDetectorListener l) {
        this.fd_listeners.addElement(l);
    }

    public void FdRemoveFailureDetectorListener(FailureDetectorListener l) {
        this.fd_listeners.removeElement(l);
    }

    public void FdSetInitialMonitoredMembers(Vector monitored_members) {
        this.members = monitored_members;
    }

    public void FdAddMonitoredMember(UnicastAddress new_member) {
        Vector vector = this.members;
        synchronized (vector) {
            this.members.addElement(new_member);
        }
    }

    public void FdRemoveMonitoredMember(UnicastAddress old_member) {
        Vector vector = this.members;
        synchronized (vector) {
            this.members.removeElement(old_member);
        }
    }

    public void FdAddSuspectableListener(Suspectable l) {
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    public void FdSetInterval(long i) {
        this.interval = i;
    }

    public void FdSetTimeout(long t) {
        this.timeout = t;
    }

    public OID FdGetAddress() {
        return this.my_oid;
    }

    public void FdSetAddress(OID address) {
        this.my_oid = address;
        this.my_addr = new UnicastAddress(this.my_oid);
        this.my_addr.SetPort(this.dispatcher.GetTransport().GetInPort());
    }

    public void FdStart() {
        if (this.members.size() <= 1) {
            this.coordinator = new Thread(this);
            this.coordinator.start();
            this.NotifyFdListeners(new MethodCall("CoordinatorChosen"));
        } else {
            this.timer = new TimerThread();
            this.timer.start();
        }
    }

    public void FdStop() {
        if (this.coordinator != null) {
            this.coordinator.stop();
            this.coordinator = null;
        }
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public OID FdHeartbeat() {
        if (this.coordinator != null) {
            return null;
        }
        System.out.println("Received heartbeat\n");
        this.last_heartbeat_received = System.currentTimeMillis();
        this.next_coord = 0;
        this.NotifyFdListeners(new MethodCall("ReceivedHeartbeat", this.my_oid));
        return this.my_oid;
    }

    private void SendNewCoordinatorMessage() {
        System.out.println("Requesting new coordinator");
        try {
            RpcMessage m = new RpcMessage((Address)new MultipleAddress(this.members), (Address)this.my_addr, new MethodCall("FdNewCoordinator"));
            m.SetOneway(true);
            this.dispatcher.Send(m);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void FdNewCoordinator() {
        OID new_coord = null;
        if (this.members.size() <= 1) {
            System.out.println("FdImpl.FdNewCoordinator(): I'm the only member !");
            return;
        }
        if (this.next_coord >= this.members.size()) {
            this.next_coord = 0;
        }
        if ((new_coord = ((UnicastAddress)this.members.elementAt(this.next_coord)).GetOid()) == null) {
            System.out.println("FdImpl.FdNewCoordinator(): could not find a member that is still alive ! cannot choose a new coordinator !");
            return;
        }
        this.NotifyFdListeners(new MethodCall("CheckForCoord", new_coord));
        if (this.my_oid.equals(new_coord)) {
            this.FdStop();
            this.coordinator = new Thread(this);
            this.coordinator.start();
            System.out.println("I (" + this.my_oid + ") am the new coordinator !");
            this.next_coord = 0;
            this.NotifyFdListeners(new MethodCall("CoordinatorChosen"));
        } else {
            System.out.println("I (" + this.my_oid + ") am NOT the new coordinator !");
            ++this.next_coord;
        }
    }

    private void RemoveOid(Vector v, OID oid) {
        int i = 0;
        while (i < v.size()) {
            UnicastAddress tmp = (UnicastAddress)v.elementAt(i);
            if (tmp != null && oid.equals(tmp.GetOid())) {
                v.removeElement(tmp);
                return;
            }
            ++i;
        }
    }

    public void run() {
        Vector rsp = null;
        int size = 0;
        while (true) {
            try {
                while (true) {
                    if (this.members.size() > 1) {
                        Vector copy;
                        Vector vector = this.members;
                        synchronized (vector) {
                            copy = (Vector)this.members.clone();
                        }
                        this.RemoveOid(copy, this.my_oid);
                        System.out.println("Sending heartbeat");
                        RpcMessage hb_msg = new RpcMessage((Address)new MultipleAddress(copy), (Address)this.my_addr, new MethodCall("FdHeartbeat"));
                        size = copy.size();
                        try {
                            rsp = this.dispatcher.SendRpcGetAll(hb_msg, size, this.timeout);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (rsp != null) {
                            int i = 0;
                            while (i < rsp.size()) {
                                OID tmp_oid = (OID)rsp.elementAt(i);
                                if (tmp_oid != null) {
                                    this.RemoveOid(copy, tmp_oid);
                                }
                                ++i;
                            }
                        } else {
                            System.err.println("FdImpl.run(): received no rsp to heartbeat message: suspecting all members !");
                        }
                        if (copy.size() > 0) {
                            if (copy.size() > 1) {
                                int i = 0;
                                while (i < this.listeners.size()) {
                                    ((Suspectable)this.listeners.elementAt(i)).Suspect(copy);
                                    ++i;
                                }
                            } else {
                                int i = 0;
                                while (i < this.listeners.size()) {
                                    Suspectable s = (Suspectable)this.listeners.elementAt(i);
                                    s.Suspect((UnicastAddress)copy.elementAt(0));
                                    ++i;
                                }
                            }
                        }
                    }
                    Thread.currentThread();
                    Thread.sleep(this.interval);
                }
            }
            catch (Exception e) {
                System.err.println(e);
                continue;
            }
            break;
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("Implementation of FailureDetector (FdImpl):\n");
        if (this.members != null) {
            ret.append("Members to monitor: " + this.members.size() + "\n");
        }
        if (this.listeners != null) {
            ret.append("Listeners: " + this.listeners.size() + "\n");
        }
        ret.append("Mointoring interval: " + this.interval + "\n");
        ret.append("My OID: " + this.my_oid + "\n");
        ret.append("My address: " + this.my_addr);
        return ret.toString();
    }

    final /* synthetic */ void access$0() {
        this.SendNewCoordinatorMessage();
    }

    private class TimerThread
    extends Thread {
        private long curr_time;
        private long max_retries = 3L;
        private long num_tries;

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(FdImpl.this.interval);
                        this.curr_time = System.currentTimeMillis();
                        if (this.curr_time - FdImpl.this.last_heartbeat_received > FdImpl.this.interval) {
                            ++this.num_tries;
                            if (this.num_tries < this.max_retries) continue;
                            FdImpl.this.access$0();
                            this.num_tries = 0L;
                            continue;
                        }
                        this.num_tries = 0L;
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                    continue;
                }
                break;
            }
        }

        TimerThread() {
            FdImpl.this = FdImpl.this;
        }
    }
}

