/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups;

import JavaGroups.DispatcherThread;
import JavaGroups.Group;
import JavaGroups.Message;
import JavaGroups.MessageListener;
import JavaGroups.MessageQueue;
import JavaGroups.OID;
import JavaGroups.Protocols.UDP;
import JavaGroups.RpcMessage;
import JavaGroups.Transport;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Dispatcher
implements MessageListener {
    private Hashtable registered_objects = new Hashtable();
    private Hashtable registered_groups = new Hashtable();
    private MessageQueue dispatch_queue = new MessageQueue();
    private Transport transport;
    private final int NUM_DISPATCHER_THREADS = 5;
    private DispatcherThread[] dispatcher_threads = new DispatcherThread[5];

    public Dispatcher(Transport t) throws Exception {
        if (t == null) {
            throw new Exception("Creation of dispatcher failed: no transport object");
        }
        this.transport = t;
        this.transport.SetMessageListener(this);
        int i = 0;
        while (i < 5) {
            this.dispatcher_threads[i] = new DispatcherThread(this);
            this.dispatcher_threads[i].start();
            ++i;
        }
    }

    public Hashtable GetRegisteredObjects() {
        return this.registered_objects;
    }

    public Hashtable GetRegisteredGroups() {
        return this.registered_groups;
    }

    public MessageQueue GetDispatchQueue() {
        return this.dispatch_queue;
    }

    public Transport GetTransport() {
        return this.transport;
    }

    public synchronized OID Register(Object obj) {
        OID oid = OID.MakeOid();
        this.registered_objects.put(oid, obj);
        return oid;
    }

    public void UnRegister(Object obj) {
        Enumeration e = this.registered_objects.keys();
        while (e.hasMoreElements()) {
            OID key = (OID)e.nextElement();
            Object val = this.registered_objects.get(key);
            if (val != obj) continue;
            this.registered_objects.remove(key);
            return;
        }
    }

    public Object FindObject(OID oid) {
        return this.registered_objects.get(oid);
    }

    public void Register(Group group) {
        this.registered_groups.put(group.GetName(), group);
    }

    public void UnRegister(Group group) {
        Enumeration e = this.registered_groups.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Group val = (Group)this.registered_groups.get(key);
            if (val != group) continue;
            this.registered_groups.remove(key);
            return;
        }
    }

    public Group FindGroup(String group_name) {
        return (Group)this.registered_groups.get(group_name);
    }

    public void Receive(Message msg) {
        try {
            this.dispatch_queue.Add(msg);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public synchronized void Send(Message msg) throws Exception {
        this.transport.Send(msg);
    }

    public Message SendMsg(Message msg, long timeout) throws Exception {
        return this.transport.SendMsg(msg, timeout);
    }

    public Message SendMsg(Message msg) throws Exception {
        return this.SendMsg(msg, 0L);
    }

    public Vector SendMsgGetAll(Message msg, int expected_responses, long timeout) throws Exception {
        return this.transport.SendMsgGetAll(msg, expected_responses, timeout);
    }

    public Vector SendMsgGetAll(Message msg, int expected_responses) throws Exception {
        return this.SendMsgGetAll(msg, expected_responses, -1L);
    }

    public Object SendRpc(RpcMessage msg, long timeout) throws Exception {
        return this.transport.SendRpc(msg, timeout);
    }

    public Object SendRpc(RpcMessage msg) throws Exception {
        return this.SendRpc(msg, 0L);
    }

    public Vector SendRpcGetAll(RpcMessage msg, int exp_responses, long timeout) throws Exception {
        return this.transport.SendRpcGetAll(msg, exp_responses, timeout);
    }

    public Vector SendRpcGetAll(RpcMessage msg, int exp_responses) throws Exception {
        return this.SendRpcGetAll(msg, exp_responses, 0L);
    }

    public void JoinMulticastGroup(InetAddress mcast_addr, int port) {
        UDP udp_prot = null;
        try {
            udp_prot = (UDP)this.transport.FindProtocol("UDP");
            udp_prot.JoinMulticastGroup(mcast_addr, port);
        }
        catch (Exception e) {
            System.err.println(e);
            System.err.println("No UDP protocol was found");
            return;
        }
    }

    public void JoinMulticastGroup(String mcast_addr, int port) {
        try {
            this.JoinMulticastGroup(InetAddress.getByName(mcast_addr), port);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void LeaveMulticastGroup(InetAddress mcast_addr, int port) {
        UDP udp_prot = null;
        try {
            udp_prot = (UDP)this.transport.FindProtocol("UDP");
            udp_prot.LeaveMulticastGroup(mcast_addr, port);
        }
        catch (Exception e) {
            System.err.println(e);
            System.err.println("No UDP protocol was found");
            return;
        }
    }

    public void LeaveMulticastGroup(String mcast_addr, int port) {
        try {
            this.LeaveMulticastGroup(InetAddress.getByName(mcast_addr), port);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

