/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups;

import JavaGroups.Protocol;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Configurator {
    public Protocol SetupProtocolStack(String configuration) {
        Protocol protocol_stack = null;
        try {
            Vector protocol_configs = this.ParseConfigurations(configuration);
            Vector protocols = this.CreateProtocols(protocol_configs);
            protocol_stack = this.ConnectProtocols(protocols);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return protocol_stack;
    }

    private Vector ParseComponentStrings(String config_str, int delimiter) {
        Vector<String> retval = new Vector<String>();
        StringBuffer buf = new StringBuffer();
        boolean index = false;
        boolean esc = false;
        int i = 0;
        while (i < config_str.length()) {
            char ch = config_str.charAt(i);
            if (ch == '\\') {
                buf.append(config_str.charAt(++i));
            } else if (ch == delimiter) {
                retval.addElement(buf.toString());
                buf = new StringBuffer();
            } else {
                buf.append(config_str.charAt(i));
            }
            ++i;
        }
        if (buf.length() > 0) {
            retval.addElement(buf.toString());
        }
        return retval;
    }

    private Vector ParseConfigurations(String configuration) {
        Vector<ProtocolConfiguration> retval = new Vector<ProtocolConfiguration>();
        Vector component_strings = this.ParseComponentStrings(configuration, 58);
        if (component_strings == null) {
            return null;
        }
        int i = 0;
        while (i < component_strings.size()) {
            String component_string = (String)component_strings.elementAt(i);
            ProtocolConfiguration protocol_config = new ProtocolConfiguration(component_string);
            retval.addElement(protocol_config);
            ++i;
        }
        return retval;
    }

    private Vector CreateProtocols(Vector protocol_configs) {
        Vector<Protocol> retval = new Vector<Protocol>();
        int i = 0;
        while (i < protocol_configs.size()) {
            ProtocolConfiguration protocol_config = (ProtocolConfiguration)protocol_configs.elementAt(i);
            Protocol layer = protocol_config.access$0();
            retval.addElement(layer);
            ++i;
        }
        return retval;
    }

    private Protocol ConnectProtocols(Vector protocol_list) {
        Protocol current_layer = null;
        Protocol next_layer = null;
        System.out.println("Connecting " + protocol_list.size() + " protocols: ");
        int i = 0;
        while (i < protocol_list.size()) {
            current_layer = (Protocol)protocol_list.elementAt(i);
            try {
                next_layer = (Protocol)protocol_list.elementAt(i + 1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                break;
            }
            current_layer.SetReceiveProtocol(next_layer);
            next_layer.SetSendProtocol(current_layer);
            ++i;
        }
        System.out.println("Done.");
        int i2 = 0;
        while (i2 < protocol_list.size()) {
            current_layer = (Protocol)protocol_list.elementAt(i2);
            System.out.println("Starting protocol " + current_layer.GetName());
            current_layer.StartWork();
            ++i2;
        }
        return current_layer;
    }

    public Protocol FindProtocol(Protocol prot_stack, String name) {
        Protocol curr_prot = prot_stack;
        while (true) {
            String s;
            if ((s = curr_prot.GetName()) == null) {
                continue;
            }
            if (s.equals(name)) {
                return curr_prot;
            }
            if ((curr_prot = curr_prot.GetSendProtocol()) == null) break;
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Configurator <string>");
            System.exit(0);
        }
        String config_str = args[0];
        Configurator conf = new Configurator();
        Vector protocol_configs = conf.ParseConfigurations(config_str);
        Vector protocols = conf.CreateProtocols(protocol_configs);
        Protocol protocol_stack = conf.ConnectProtocols(protocols);
        System.err.println(protocols);
    }

    final /* synthetic */ Vector access$0(String $0, int $1) {
        return this.ParseComponentStrings($0, $1);
    }

    public class ProtocolConfiguration {
        private String protocol_name;
        private String properties_str;
        private Properties properties = new Properties();
        private final String protocol_prefix = "JavaGroups.Protocols";

        private void SetContents(String config_str) {
            Vector components;
            int index = config_str.indexOf(40);
            int end_index = config_str.lastIndexOf(41);
            if (index == -1) {
                this.protocol_name = config_str;
            } else if (end_index == -1) {
                System.err.println("Closing ')' not found in " + config_str);
                System.err.println("Properties cannot be set !");
            } else {
                this.properties_str = config_str.substring(index + 1, end_index);
                this.protocol_name = config_str.substring(0, index);
            }
            if (this.properties_str != null && (components = Configurator.this.access$0(this.properties_str, 59)).size() > 0) {
                int i = 0;
                while (i < components.size()) {
                    String comp = (String)components.elementAt(i);
                    index = comp.indexOf(61);
                    if (index == -1) {
                        System.err.println("'=' not found in " + comp);
                    } else {
                        String name = comp.substring(0, index);
                        String value = comp.substring(index + 1, comp.length());
                        ((Hashtable)this.properties).put(name, value);
                    }
                    ++i;
                }
            }
        }

        private ProtocolConfiguration(String config_str) {
            Configurator.this = Configurator.this;
            this.SetContents(config_str);
        }

        private String GetProtocolNAme() {
            return this.protocol_name;
        }

        private Properties GetProperties() {
            return this.properties;
        }

        private Protocol CreateLayer() {
            Protocol retval = null;
            if (this.protocol_name == null) {
                return null;
            }
            try {
                this.protocol_name = "JavaGroups.Protocols." + this.protocol_name;
                System.out.println("Creating instance of " + this.protocol_name + " protocol");
                retval = (Protocol)Class.forName(this.protocol_name).newInstance();
                if (retval == null) {
                    System.err.println("Failed !");
                }
            }
            catch (InstantiationException inst_ex) {
                System.err.println(inst_ex);
                System.err.println("An instance of " + this.protocol_name + " could not be created. Please check that it implements" + " interface Protocol and that is has a public empty" + " constructor !");
            }
            catch (Exception e) {
                System.err.println(e);
                return null;
            }
            if (this.properties != null) {
                retval.SetProperties(this.properties);
            }
            return retval;
        }

        public String toString() {
            StringBuffer retval = new StringBuffer();
            retval.append("Protocol: ");
            if (this.protocol_name == null) {
                retval.append("<unknown>");
            } else {
                retval.append(this.protocol_name);
            }
            if (this.properties != null) {
                retval.append("(" + this.properties + ")");
            }
            return retval.toString();
        }

        final /* synthetic */ Protocol access$0() {
            return this.CreateLayer();
        }
    }
}

