
import java.rmi.*;
import java.util.*;
import JavaGroups.JavaStack.*;



class GetGossip {


    public static void main(String args[]) {
	String         host="janet";
	int            port=12001;
	String         arg, next_arg, remote_addr, groupname="DemoGroup";
	Gossip         srv=null;
	Vector         oids;
	final String   name="GOSSIP_SERVER";


	for(int i=0; i < args.length; i++) {
	    arg=args[i];
	    if(arg.equals("-help")) {
		System.out.println("GetGossip [-group <groupname>] [-host <hostname>] " + 
				   "[-port <registry port> ]");
		return;
	    }
	    else if(arg.equals("-port")) {
		port=new Integer(args[++i]).intValue();
		continue;
	    }
	    else if(arg.equals("-host")) {
		host=args[++i];
		continue;
	    }
	    else if(arg.equals("-group")) {
		groupname=args[++i];
		continue;
	    }
	}


	try {
	    remote_addr="//" + host + ":" + port + "/" + name;
	    System.out.println("Looking up remote Gossip server (" + remote_addr + "):");
	    srv=(Gossip)Naming.lookup(remote_addr);
	    System.out.println("Found.");
	    oids=srv.Get(groupname);
	    if(oids != null && oids.size() > 0) {
		System.out.println("The following Oids are currently registered with the Gossip " +
				   "server:");
		for(int i=0; i < oids.size(); i++)
		    System.out.println(oids.elementAt(i));
	    }
	    else
		System.out.println("The Gossip server has currently no Oids registered");
	}
	catch(Exception e) {
	    System.err.println(e);
	}

    }
}


