package JavaGroups.JavaStack;

import java.net.*;


/**
 * ViewIds are used for ordering views (each view has a ViewId and a list of members).
 * Ordering between views is important for example in a virtual synchrony protocol where
 * all views seen by a member have to be ordered.
 */
public class ViewId implements java.io.Serializable {
    Address       coord_addr=null;   // Address of the issuer of this view
    long          id=0;              // Lamport time of the view


    
    public ViewId(Address coord_addr) {
	this.coord_addr=coord_addr;
	if(coord_addr == null) {
	    System.err.println("ViewId(): coord_addr cannot be null !");
	    //JavaGroups.Util.DumpStack(true);
	}
    }


    public ViewId(Address coord_addr, long id) {
	this.coord_addr=coord_addr;
	this.id=id;
	if(coord_addr == null) {
	    System.err.println("ViewId(): coord_addr cannot be null !");
	    //JavaGroups.Util.DumpStack(true);
	}
    }

    public long     GetId()                            {return id;}
    public void     SetId(long new_id)                 {id=new_id;}
    public Address  GetCoordAddress()                  {return coord_addr;}
    public void     SetCoordAddress(Address new_addr)  {coord_addr=new_addr;}
    

    public synchronized void Increment() {
	id++;
    }
    

    public String toString() {
	return "[" + coord_addr + ", id=" + id + "]";
    }

    public ViewId Copy() {
	return new ViewId(coord_addr, id);
    }



    /**
     * Establishes an order between 2 ViewIds. First compare on id. <em>Compare on coord_addr
     * only if necessary</em> (i.e. ids are equal) !
     * @return 0 for equality, value less than 0 if smaller, greater than 0 if greater.
     */
    public int Compare(ViewId other) {
	int rc;

	try {
	    //	    return id > other.id ? 1 : id < other.id ? -1 : coord_addr.Compare(other.coord_addr);
	    return id > other.id ? 1 : id < other.id ? -1 : 0;
	}
	catch(NullPointerException e) {
	    System.err.println("ViewId.Compare(): " + e);
	    throw e;
	}
    }



    public boolean equals(Object other_view) {
	return Compare((ViewId)other_view) == 0 ? true : false;
    }

//     public int hashCode() {
// 	int retval=coord_addr != null ? coord_addr.hashCode() : 0;
// 	retval+=id;
// 	return retval;
//     }




    public static void main(String args[]) {
	ViewId  v1, v2, v3;
	int     rc;

	try {
	    v1=new ViewId(new Address(InetAddress.getByName("janet"), 1000));
	    v2=new ViewId(new Address(InetAddress.getByName("gulag"), 1000));

	    v3=v1.Copy();
	    rc=v1.Compare(v2);
	    System.out.println("v1=" + v1 + "\nv2=" + v2 + "\nrc=" + rc + "\nv3=" + v3);
	}
	catch(Exception e) {
	    System.err.println(e);
	}

    }
}
