package JavaGroups.JavaStack.Protocols;

import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;





class ViewCaster implements Runnable {
    Queue    queue=new Queue();
    Integer  mutex=null;
    RpcGMS   gms=null;
    Thread   thread=null;

    
    class ViewItem {
	View v=null;

	ViewItem(View v) {this.v=v;}
    }


    ViewCaster(RpcGMS gms, Integer mutex) {
	this.gms=gms; this.mutex=mutex;
    }

    
    public void Add(View v) {
	try {
	    queue.Add(new ViewItem(v));
	}
	catch(Exception e) {
	    System.err.println("ViewCaster.Add(): " + e);
	}
    }


    public void Start() {
	if(thread == null) {
	    thread=new Thread(this, "ViewCasterThread");
	    thread.start();
	}
    }

    
    public void Stop() {
	queue.Close(false);  // close queue immediately
	if(thread != null) {
	    thread.stop();  // should already have terminated by Close() in most cases
	    thread=null;
	}
    }


    /**
       Wait until all views on the queue have been mcast, and then return.
     */
    public void Flush() {
	queue.Close(true);
    }


    public void run() {
	ViewItem  item;
	View      v;


	while(true) {
	    try {
		item=(ViewItem)queue.Remove();
		v=item.v;
		 synchronized(mutex) {
		     ;
		 }
		 gms.CastViewChange(v);
	    }
	    catch(QueueClosed closed) {
		queue.Reset();
		break;
	    }
	}
    }

}







public class RpcCoordGmsImpl extends RpcGmsImpl {
    private static RpcCoordGmsImpl  impl=null;
    private        Integer          view_caster_mutex=new Integer(0);
    private        ViewCaster       view_caster=null;
    private        boolean          leaving=false;

    private RpcCoordGmsImpl(RpcGMS gms) {
	view_caster=new ViewCaster(gms, view_caster_mutex);
    }

    public static RpcCoordGmsImpl CreateInstance(RpcGMS gms) {
	if(impl == null)
	    impl=new RpcCoordGmsImpl(gms);
	impl.gms=gms;
	impl.leaving=false;
	return impl;
    }



    public void Join(Address mbr) {
	WrongMethod("Join");
    }



    public void Leave(Address mbr) {
	if(mbr.equals(gms.local_addr))
	    leaving=true;
	HandleLeave(mbr);

	synchronized(view_caster_mutex) {  // flush all outstanding view changes
	    view_caster.Flush();
	}
    }



    public void Suspect(Address mbr) {

	System.out.println("RpcCoord.Suspect(" + mbr + ")");
	
	HandleSuspect(mbr);
	System.out.println("done");
    }


    public void Merge(Vector new_mbrs) {
	
    }



    public synchronized JoinRsp HandleJoin(Address mbr) {
	Vector    new_mbrs=new Vector();
	View      v;     // view to be returned *and* mcast to all members


	synchronized(gms.view_mutex) {

	    System.out.println(">>>> HandleJoin(" + mbr + ")");
	    
	    if(gms.local_addr.equals(mbr)) {
		System.err.println("RpcCoordGmsImpl.Join(): cannot join myself !");
		return new JoinRsp(JoinRsp.JOIN_FAILED);
	    }
	    
	    if(gms.members.Contains(mbr)) {
		System.err.println("RpcCoordGmsImpl.Join(): member " + mbr + " already present !");
		return new JoinRsp(JoinRsp.ALREADY_JOINED, gms.MakeView(gms.members.GetMembers()));
	    }
	    
	    new_mbrs.addElement(mbr);
	    v=gms.GetNextView(new_mbrs, null);    // compute new view
	    
	    // Set temporary membership in UDP layer so that multicast gets sent to
	    // the correct destinations
	    Event view_event=new Event(Event.TMP_VIEW, v);
	    gms.PassDown(view_event); // needed e.g. by failure detector or UDP
	}


	synchronized(view_caster_mutex) {
	    // We have to ensure that we return a JOIN_OK response *before* mcasting
	    // the new view. Otherwise a deadlock ensues, as follows: client waits for JOIN_OK,
	    // we wait for gms.CastViewChange() to return (it is a synchronous group RPC).
	    // However, ViewChange(0 is blocked until JOIN_OK is received !
	    // (See RpcClientGmsImpl.Join())
	    
	    view_caster.Add(v);  // Cast as soon as we have left this method	    
	    return new JoinRsp(JoinRsp.JOIN_OK, v);   
	}
	


	

    }
    

    
    public boolean HandleLeave(Address mbr) {
	long      vid=0;
	Vector    suspected_mbrs=new Vector();
	View      v;     // view to be returned *and* mcast to all members
      
	synchronized(gms.view_mutex) {
	    if(!gms.members.Contains(mbr)) {
		System.err.println("RpcCoord.HandleLeave(" + mbr + "): not a member !");
		return true;
	    }
	    
	    suspected_mbrs.addElement(mbr);
	    v=gms.GetNextView(null, suspected_mbrs);

	    if(v.GetMembers().size() == 0) // we don't install new view if we are last member
		return true;
	    
	    // Set temporary membership in UDP layer so that multicast gets sent to
	    // the correct destinations
	    Event view_event=new Event(Event.TMP_VIEW, v);
	    gms.PassDown(view_event); // needed e.g. by failure detector or UDP	

	    synchronized(view_caster_mutex) {
		view_caster.Add(v);  // Cast as soon as we have left this method	    
		return true;
	    }
	}
    }



    public void HandleViewChange(ViewId new_view, Vector mbrs) {
	if(leaving) {
	    System.err.println("RpcCoordGmsImpl.HandleViewChange(): I won't install new view " +
			       new_view + " as I'm leaving");
	    return;
	}
	gms.InstallView(new_view, mbrs);  // +++ modify
    }



    public void HandleMerge(Vector new_mems, Vector suspects, long other_ltime) {
	
    }



    public void HandleSuspect(Address mbr) {

	if(mbr.equals(gms.local_addr)) {
	    System.err.println("I am the coord and am suspected: am not quitting !");
	    return;
	}

	HandleLeave(mbr);
    }



    public void CastView(View v) {
	synchronized(view_caster_mutex) {
	    view_caster.Add(v);
	}
    }



    public void Activate() {
	view_caster.Start();
    }


    public void Deactivate() {
	view_caster.Stop();
    }

}
