package JavaGroups.JavaStack.Protocols;

import JavaGroups.*;

public class JoinRsp implements java.io.Serializable {
    public static final int JOIN_OK        = 1;
    public static final int JOIN_FAILED    = 2;
    public static final int ALREADY_JOINED = 3;

    public int     type=0;
    public View    view=null;



    public JoinRsp(int type) {
	this.type=type;
    }


    public JoinRsp(int type, View view) {
	this.type=type; this.view=view;
    }

    public String toString() {
	return "[JoinRsp: type=" + Type2Str(type) +", view=" + view + "]";
    }

    private String Type2Str(int t) {
	switch(t) {
	case JoinRsp.JOIN_OK: return "JOIN_OK";
	case JoinRsp.JOIN_FAILED: return "JOIN_FAILED";
	case JoinRsp.ALREADY_JOINED: return "ALREADY_JOINED";
	default: return "<undefined>";
	}
    }
}
