package JavaGroups.JavaStack.Protocols;

import java.io.*;
import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;

/**
   Flushes all pending multicasts out of the system (sending). Called by GMS before installing a new view.
   Only the coordinator responds to a FLUSH request from the GMS: it mcasts a FLUSH_REQ to all members. When
   a member receives a FLUSH_REQ, it performs the flushing (this involves passing a FLUSH event through the
   protocol stack and the subsequent blocking of each layer until a VIEW_CHANGE is received) and returns a
   FLUSH_RSP response. When all responses have been received (minus the ones from faulty members), a FLUSH_OK
   event is passed up the stack (and received by the GMS layer).
 */

public class FLUSH extends Protocol {
    boolean            trace=false;
    Vector             members=null;
    RequestCorrelator  corr=null;

    public String  GetName() {return "FLUSH";}


    public boolean SetProperties(Properties props) {
	String     str;

	this.props=props;
	str=props.getProperty("trace");
	if(str != null) {
	    trace=new Boolean(str).booleanValue();
	    props.remove("trace");
	}
	if(props.size() > 0) {
	    System.err.println("FLUSH.SetProperties(): the following properties are not recognized:");
	    props.list(System.out);
	    return false;
	}
	return true;
    }


    /** Just remove if you don't need to reset any state */
    public void Reset() {}




    public void Up(Event evt) {
	Message msg;

	switch(evt.GetType()) {

	case Event.START:
	    // Start work
	    PassUp(evt);
	    break;

	case Event.MSG:
	    msg=(Message)evt.GetArg();
	    // Do something with the event, e.g. extract the message and remove a header.
	    // Optionally pass up
	    break;

	default:
	    PassUp(evt);            // Pass up to the layer above us
	    break;
	}
    }





    public void Down(Event evt) {
	Message msg;

	switch(evt.GetType()) {
	case Event.STOP:
	    // Stop work
	    PassDown(evt);
	    break;

	case Event.TMP_VIEW:
	case Event.VIEW_CHANGE:
	    Vector tmp;
	    if((tmp=(Vector)((View)evt.GetArg()).GetMembers()) != null)
		members=tmp;
	    PassDown(evt);
	    break;

	case Event.MSG:
	    msg=(Message)evt.GetArg();
	    // Do something with the event, e.g. add a header to the message
	    // Optionally pass down
	    break;
	    
	default:
	    PassDown(evt);          // Pass on to the layer below us
	    break;
	}
    }



}
