package JavaGroups.Gui;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import JavaGroups.*;
import JavaGroups.Observer;
import JavaGroups.Event;



class EventHandler extends WindowAdapter {
    Frame f;
    
    public EventHandler(Frame f) {this.f=f;}

    public void windowClosing(WindowEvent e) {
	f.dispose();
    }
}





public class QueueViewer extends Frame implements Observer {
    Queue       up=null, dn=null;
    List        up_queue=new List();
    List        dn_queue=new List();
    final Font  def_font=new Font("Helvetica", Font.PLAIN, 12);
    Vector      up_vec=new Vector(), dn_vec=new Vector();
    Panel       queue_panel=new Panel();
    Panel       button_panel=new Panel();
    Button      clear_up=new Button("Clear Up");
    Button      clear_dn=new Button("Clear Dn");
    Button      update=new Button("Update");



    public QueueViewer(String name, Queue up, Queue dn) {
	this.up=up; this.dn=dn;
	setSize(500, 200);
	setLayout(new BorderLayout());
	addWindowListener(new EventHandler(this));
	setTitle(name);

	queue_panel.setLayout(new GridLayout(0,2));
	queue_panel.add(up_queue);
	queue_panel.add(dn_queue);

	button_panel.setLayout(new FlowLayout());
	button_panel.add(clear_up);
	button_panel.add(clear_dn);
	button_panel.add(update);

	add("Center", queue_panel);
	add("South",  button_panel);
	
	setBackground(Color.white);
	setFont(def_font);
	up_queue.setMultipleMode(false);
	dn_queue.setMultipleMode(false);

	SetEventHandlers();
    }



    void SetEventHandlers() {
	clear_up.addActionListener(
				   new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		up_queue.removeAll();
	    }
	});

	clear_dn.addActionListener(
				   new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		dn_queue.removeAll();
	    }
	});

	update.addActionListener(
				   new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		Update();
	    }
	});
	
    }


    String Object2Str(Object obj) {
	Event    evt;
	byte[]   buffer;
	Message  msg;
	Object   tmp;

	if(obj instanceof Event) {
	    evt=(Event)obj;
	    if(evt.GetType() == Event.MSG) {
		msg=(Message)evt.GetArg();
		if(msg.GetBuffer() != null) {
		    try {
			tmp=Util.ObjectFromByteBuffer(msg.GetBuffer());
			return tmp.toString();
		    }
		    catch(Exception e) {}
		}
		else if(msg.PeekHeader() != null) {
		    return evt.toString() + " [hdr=" + msg.PeekHeader().toString() + "]";
		}
		else
		    return evt.toString();
	    }
	    return evt.toString();
	}
	return obj.toString();
    }


    public synchronized void Update() {

	Vector upvec=up.GetContents();
	Vector dnvec=dn.GetContents();

 	up_queue.removeAll();
	dn_queue.removeAll();

	for(int i=0; i < upvec.size(); i++)
	    up_queue.add(Object2Str(upvec.elementAt(i)));

	for(int i=0; i < dnvec.size(); i++)
	    dn_queue.add(Object2Str(dnvec.elementAt(i)));
    }


    public void ClearUpQueue() {
	synchronized(up_vec) {
	    up_vec.removeAllElements();
	}
	Update();
    }


    public void ClearDownQueue() {
	synchronized(dn_vec) {
	    dn_vec.removeAllElements();
	}
	Update();
    }




    public synchronized void Up(Object obj) {
	up_vec.addElement(obj);
	up_queue.add(Object2Str(obj));
    }


    public synchronized void Down(Object obj) {
	dn_vec.addElement(obj);
	dn_queue.add(Object2Str(obj));
    }


    public synchronized void PassUp(Object obj) {
	up_vec.addElement(obj);
	up_queue.add("PassUp --> " + Object2Str(obj));
    }


    public synchronized void PassDown(Object obj) {
	dn_vec.addElement(obj);
	dn_queue.add("PassDown --> " + Object2Str(obj));
    }




    public static void main(String[] args) {
	Queue       q1=new Queue(), q2=new Queue();
	QueueViewer v=new QueueViewer("Demo Viewer", q1, q2);


	v.show();

	
	for(int i=0; i < 50; i++) {
	    if(i % 2 == 0)
		v.Up("Number #" + i);
	    else
		v.Down("Number #" + i);
	    Util.Sleep(10);
	}
    }
    
}
