package JavaGroups;



/**
 * Used for inter-stack and intra-stack communication.
 */
public class Event implements java.io.Serializable {
    public static final int START                     =  1;
    public static final int START_OK                  =  2;
    public static final int STOP                      =  3;
    public static final int STOP_OK                   =  4;
    public static final int MSG                       =  5;
    public static final int CONNECT                   =  6;  // arg = group address (string)
    public static final int CONNECT_OK                =  7;    
    public static final int DISCONNECT                =  8;  // arg = member address (Address)
    public static final int DISCONNECT_OK             =  9;
    public static final int VIEW_CHANGE               = 10;  // arg = View
    public static final int GET_LOCAL_ADDRESS         = 11;
    public static final int SET_LOCAL_ADDRESS         = 12;
    public static final int FLUSH                     = 13;
    public static final int FLUSH_OK                  = 14;
    public static final int SUSPECT                   = 15;  // arg = Address of suspected member
    public static final int BLOCK                     = 16;
    public static final int BLOCK_OK                  = 17;
    public static final int FIND_INITIAL_MBRS         = 18;
    public static final int FIND_INITIAL_MBRS_OK      = 19;  // arg = Vector of PingRsps
    public static final int MERGE                     = 20;  // arg = Vector of Objects
    public static final int TMP_VIEW                  = 21;  // arg = View
    public static final int BECOME_SERVER             = 22;  // sent when client has joined group


    public static final int GET_APPLSTATE             = 23;  // get state from appl (arg=requestor)
    public static final int GET_APPLSTATE_OK          = 24;  // arg = Serializable (state)
    public static final int GET_STATE                 = 25;  // arg = Integer 0=coord, 1=all
    public static final int GET_STATE_OK              = 26;  // arg = Object or Vector (state(s))
    public static final int STATE_RECEIVED            = 27;  // arg = state


    private int     type=0;       // type of event
    private Object  arg=null;     // must be serializable if used for inter-stack communication


    public Event(int type) {
	this.type=type;
    }

    public Event(int type, Object arg) {
	this.type=type;
	this.arg=arg;
    }

    public int     GetType()                {return type;}
    public void    SetType(int type)        {this.type=type;}

    public Object  GetArg()                 {return arg;}
    public void    SetArg(Object arg)       {this.arg=arg;}



    public static String Type2String(int t) {
	switch(t) {
	case START:                  return "START";
	case START_OK:               return "START_OK";
	case STOP:	             return "STOP"; 
	case STOP_OK:	             return "STOP_OK";
	case MSG:	             return "MSG";
	case CONNECT:	             return "CONNECT";
	case CONNECT_OK:	     return "CONNECT_OK";
	case DISCONNECT:	     return "DISCONNECT";
	case DISCONNECT_OK: 	     return "DISCONNECT_OK";
	case VIEW_CHANGE:	     return "VIEW_CHANGE";
	case GET_LOCAL_ADDRESS:	     return "GET_LOCAL_ADDRESS";
	case SET_LOCAL_ADDRESS:	     return "SET_LOCAL_ADDRESS";
	case FLUSH:	             return "FLUSH";
	case FLUSH_OK:	             return "FLUSH_OK";
	case SUSPECT:                return "SUSPECT";
	case BLOCK:	             return "BLOCK";
	case BLOCK_OK:               return "BLOCK_OK";
	case FIND_INITIAL_MBRS:	     return "FIND_INITIAL_MBRS";
	case FIND_INITIAL_MBRS_OK:   return "FIND_INITIAL_MBRS_OK";
	case MERGE:	             return "MERGE";
	case TMP_VIEW:	             return "TMP_VIEW";
	case BECOME_SERVER:	     return "BECOME_SERVER";
	case GET_APPLSTATE:          return "GET_APPLSTATE";
	case GET_APPLSTATE_OK:       return "GET_APPLSTATE_OK";
	case GET_STATE:              return "GET_STATE";
	case GET_STATE_OK:           return "GET_STATE_OK";
	case STATE_RECEIVED:         return "STATE_RECEIVED";
	default:                     return "UNDEFINED";
	}
    }

    public String toString() {
	StringBuffer ret=new StringBuffer();
	ret.append("Event[type=" + Type2String(type) + ", arg=" + arg + "]");
	return ret.toString();
    }
}

