/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups.Protocols;

import JavaGroups.McastCapable;
import JavaGroups.Message;
import JavaGroups.MessageQueue;
import JavaGroups.Protocol;
import JavaGroups.Protocols.UdpMcastReceiverThread;
import JavaGroups.Protocols.UdpReceiverThread;
import JavaGroups.Protocols.UdpSenderThread;
import java.net.InetAddress;
import java.util.Properties;
import java.util.Vector;

public class UDP
implements Protocol,
McastCapable {
    private Protocol send_prot;
    private Protocol receive_prot;
    private MessageQueue receive_queue = new MessageQueue();
    private MessageQueue send_queue = new MessageQueue();
    private int in_port = -1;
    private UdpSenderThread sender_thread;
    private UdpReceiverThread receiver_thread;
    private boolean loopback = true;
    private Properties properties;
    private int num_outsocks = 1;
    private Vector mcast_receiver_threads = new Vector();

    public boolean GetLoopback() {
        return this.loopback;
    }

    public Properties GetProperties() {
        return this.properties;
    }

    public int GetInPort() {
        return this.in_port;
    }

    public String GetName() {
        return "UDP";
    }

    public Protocol GetReceiveProtocol() {
        return this.receive_prot;
    }

    public Protocol GetSendProtocol() {
        return this.send_prot;
    }

    public MessageQueue GetSendQueue() {
        return this.send_queue;
    }

    public MessageQueue GetReceiveQueue() {
        return this.receive_queue;
    }

    public void SetInPort(int p) {
        this.in_port = p;
    }

    public void SetProperties(Properties props) {
        this.properties = props;
        String str = this.properties.getProperty("in_port");
        if (str != null) {
            this.in_port = Integer.parseInt(str);
        }
        if ((str = this.properties.getProperty("num_outsockets")) != null) {
            this.num_outsocks = Integer.parseInt(str);
        }
        if ((str = this.properties.getProperty("loopback")) != null) {
            this.loopback = new Boolean(str);
        }
    }

    public void SetReceiveProtocol(Protocol receive_protocol) {
        if (this.receiver_thread != null) {
            this.receiver_thread.suspend();
        }
        this.receive_prot = receive_protocol;
        if (this.receiver_thread != null) {
            this.receiver_thread.resume();
        }
    }

    public void SetSendProtocol(Protocol send_protocol) {
        if (this.sender_thread != null) {
            this.sender_thread.suspend();
        }
        this.send_prot = send_protocol;
        if (this.sender_thread != null) {
            this.sender_thread.resume();
        }
    }

    public void Receive(Message msg) {
        try {
            this.receive_queue.Add(msg);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void Send(Message msg) throws Exception {
        this.send_queue.Add(msg);
    }

    public void StartWork() {
        this.receiver_thread = new UdpReceiverThread(this);
        this.receiver_thread.start();
        this.sender_thread = new UdpSenderThread(this, this.num_outsocks);
        this.sender_thread.start();
    }

    public void StopWork() {
        if (this.receiver_thread != null) {
            this.receiver_thread.stop();
            this.receiver_thread = null;
        }
        if (this.sender_thread != null) {
            this.sender_thread.stop();
            this.sender_thread = null;
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("Protocol UDP(in_port=" + this.in_port + ")");
        return ret.toString();
    }

    private McastEntry FindEntry(InetAddress addr, int port) {
        McastEntry retval = null;
        int i = 0;
        while (i < this.mcast_receiver_threads.size()) {
            McastEntry tmp = (McastEntry)this.mcast_receiver_threads.elementAt(i);
            if (tmp.mcast_addr.equals(addr) && tmp.port == port) {
                return retval;
            }
            ++i;
        }
        return retval;
    }

    public void JoinMulticastGroup(InetAddress mcast_addr, int port) throws Exception {
        if (!mcast_addr.isMulticastAddress()) {
            throw new Exception("Address " + mcast_addr.getHostAddress() + " is not a multicast address");
        }
        McastEntry e = this.FindEntry(mcast_addr, port);
        if (e != null) {
            ++e.use_count;
            return;
        }
        UdpMcastReceiverThread new_thread = new UdpMcastReceiverThread(this, mcast_addr, port);
        new_thread.start();
        McastEntry new_entry = new McastEntry(mcast_addr, port);
        this.mcast_receiver_threads.addElement(new_entry);
    }

    public void LeaveMulticastGroup(InetAddress mcast_addr, int port) throws Exception {
        if (!mcast_addr.isMulticastAddress()) {
            throw new Exception("Address " + mcast_addr.getHostAddress() + " is not a multicast address");
        }
        McastEntry e = this.FindEntry(mcast_addr, port);
        if (e != null) {
            --e.use_count;
            if (e.use_count <= 0) {
                this.mcast_receiver_threads.removeElement(e);
            }
        } else {
            System.err.println("Error leaving mcast group: group was not found");
        }
    }

    private class McastEntry {
        InetAddress mcast_addr;
        int port = -1;
        int use_count = 1;
        UdpMcastReceiverThread thread;

        private McastEntry(InetAddress addr, int p) {
            UDP.this = UDP.this;
            this.mcast_addr = addr;
            this.port = p;
        }

        private void SetThread(UdpMcastReceiverThread t) {
            this.thread = t;
        }
    }
}

