/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups.Protocols;

import JavaGroups.Message;
import java.util.Hashtable;

public class SlidingWindow {
    private Hashtable msgs;
    private long lower_bound = 1L;
    private long upper_bound = 100L;
    private int window_size = 2048;
    private boolean trace = false;
    private boolean first_msg = true;

    private boolean CheckBounds(long id) {
        return id >= this.lower_bound && id <= this.upper_bound;
    }

    public SlidingWindow(int size, boolean tr) {
        this.window_size = size;
        this.msgs = new Hashtable(this.window_size);
        this.upper_bound = this.lower_bound + (long)this.window_size;
        this.trace = tr;
    }

    public SlidingWindow(boolean tr) {
        this.msgs = new Hashtable(this.window_size);
        this.upper_bound = this.lower_bound + (long)this.window_size;
        this.trace = tr;
    }

    public SlidingWindow() {
        this.msgs = new Hashtable(this.window_size);
        this.upper_bound = this.lower_bound + (long)this.window_size;
    }

    public int Size() {
        return this.msgs.size();
    }

    public long GetLowerBound() {
        return this.lower_bound;
    }

    public long GetUpperBound() {
        return this.upper_bound;
    }

    public boolean GetTrace() {
        return this.trace;
    }

    public void SetTrace(boolean tr) {
        this.trace = tr;
    }

    public void SetWindowSize(int new_size) {
        this.window_size = new_size;
        this.upper_bound = this.lower_bound + (long)this.window_size;
    }

    public void SetLowerBound(long lb) {
        this.lower_bound = lb;
        this.upper_bound = this.lower_bound + (long)this.window_size;
    }

    public synchronized void Add(Message msg) {
        long id = msg.GetReplyId();
        Long key = new Long(id);
        if (this.msgs.size() >= this.window_size) {
            if (this.trace) {
                System.err.println("SlidingWindow is full (" + this.msgs.size() + ")messages; " + "no more messages can be added ! Message is discarded");
            }
            return;
        }
        if (!this.CheckBounds(id)) {
            if (this.trace) {
                System.err.println("SlidingWindow.Add(): Message id #" + id + " out of bounds (lower bound=" + this.lower_bound + ", upper bound=" + this.upper_bound + ")");
            }
            return;
        }
        if (this.msgs.containsKey(key)) {
            if (this.trace) {
                System.err.println("Duplicate message (#" + key + ") discarded");
            }
            return;
        }
        this.msgs.put(new Long(id), msg);
    }

    public synchronized Message Remove() {
        Message retval = null;
        Long key = new Long(this.lower_bound);
        retval = (Message)this.msgs.get(key);
        if (retval != null) {
            ++this.lower_bound;
            this.upper_bound = this.lower_bound + (long)this.window_size;
            this.msgs.remove(key);
        }
        return retval;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("SlidingWindow:\nSize: " + this.msgs.size());
        ret.append("\nLower bound: " + this.lower_bound);
        ret.append("\nUpper bound: " + this.upper_bound);
        ret.append("\nWindow size: " + this.window_size);
        ret.append("\nMessages: " + this.msgs);
        return ret.toString();
    }
}

