/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups;

import JavaGroups.Address;
import JavaGroups.RawMessage;
import JavaGroups.UnicastAddress;
import java.io.Serializable;

public class Message
implements Serializable,
Cloneable {
    protected static long curr_id;
    protected long msg_id = Message.GetNextId();
    protected Address dest_addr;
    protected Address source_addr = new UnicastAddress();
    protected RawMessage data = new RawMessage();
    protected long reply_id = -1L;

    public long GetMessageId() {
        return this.msg_id;
    }

    public long GetReplyId() {
        return this.reply_id;
    }

    public Address GetDestinationAddress() {
        return this.dest_addr;
    }

    public Address GetSourceAddress() {
        return this.source_addr;
    }

    public byte[] GetData() {
        return this.data.GetData();
    }

    public Object ReadObject() {
        return this.data.ReadObject();
    }

    public Object GetObject() {
        return this.data.GetObject();
    }

    public void SetObject(Serializable obj) {
        this.data.SetObject(obj);
    }

    public int ReadInt() {
        return this.data.ReadInt();
    }

    public long ReadLong() {
        return this.data.ReadLong();
    }

    public String ReadString() {
        return this.data.ReadString();
    }

    public void SetMessageId(long id) {
        this.msg_id = id;
    }

    public void SetReplyId(long id) {
        this.reply_id = id;
    }

    public void SetDestinationAddress(Address a) {
        this.dest_addr = a;
    }

    public void SetSourceAddress(Address a) {
        this.source_addr = a;
    }

    public void SetData(byte[] d) {
        this.data.SetData(d);
    }

    public void SetData(Serializable d) {
        this.data = new RawMessage(d);
    }

    public boolean IsResponse() {
        return this.reply_id > 0L;
    }

    public static synchronized long GetNextId() {
        return ++curr_id;
    }

    public Message() {
    }

    public Message(byte[] msg) {
        this.data = new RawMessage(msg);
    }

    public Message(Address dest) {
        this.dest_addr = dest;
    }

    public Message(Serializable msg) {
        this.data = new RawMessage(msg);
    }

    public Message(Address dest, byte[] d) throws Exception {
        this.dest_addr = dest;
        this.data = new RawMessage(d);
    }

    public Message(Address dest, Serializable msg) {
        this.dest_addr = dest;
        this.data = new RawMessage(msg);
    }

    public Message(Address dest, Address src) throws Exception {
        this.dest_addr = dest;
        this.source_addr = src;
    }

    public Message(Address dest, Address src, byte[] d) throws Exception {
        this.dest_addr = dest;
        this.source_addr = src;
        this.data = new RawMessage(d);
    }

    public Message(Address dest, Address src, Serializable msg) throws Exception {
        this.dest_addr = dest;
        this.source_addr = src;
        this.data = new RawMessage(msg);
    }

    public Message MakeReply() {
        Message ret = new Message();
        ret.reply_id = this.msg_id;
        ret.dest_addr = this.source_addr;
        ret.source_addr = null;
        return ret;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("Message ID: " + this.msg_id);
        if (this.reply_id > 0L) {
            ret.append("\nReply to ID: " + this.reply_id);
        }
        ret.append("\nDestination: ");
        if (this.dest_addr != null) {
            ret.append(this.dest_addr);
        } else {
            ret.append("<no dest>");
        }
        ret.append("\nSource: ");
        if (this.source_addr != null) {
            ret.append(this.source_addr);
        } else {
            ret.append("<no src>");
        }
        ret.append("\nBuffer: (size=" + this.data.Size() + ")");
        return ret.toString();
    }

    public void SwapAddresses() {
        Address tmp = this.dest_addr;
        this.dest_addr = this.source_addr;
        this.source_addr = tmp;
    }

    public Object clone() throws CloneNotSupportedException {
        Message retval = null;
        Address dest = this.dest_addr != null ? (Address)this.dest_addr.clone() : null;
        Address src = this.source_addr != null ? (Address)this.source_addr.clone() : null;
        try {
            retval = new Message(dest, src, this.GetData());
            retval.SetMessageId(this.msg_id);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return retval;
    }

    public void Prepend(byte[] new_data) {
        this.data.Prepend(new_data);
    }

    public void Prepend(int i) {
        this.data.Prepend(i);
    }

    public void Prepend(long l) {
        this.data.Prepend(l);
    }

    public void Prepend(Serializable obj) {
        this.data.Prepend(obj);
    }

    public void Append(byte[] new_data) {
        this.data.Append(new_data);
    }

    public void Append(int i) {
        this.data.Append(i);
    }

    public void Append(long l) {
        this.data.Append(l);
    }

    public void Append(Serializable obj) {
        this.data.Append(obj);
    }

    public int RemoveInt() throws Exception {
        return this.data.RemoveInt();
    }

    public long RemoveLong() throws Exception {
        return this.data.RemoveLong();
    }

    public Object RemoveObject() throws Exception {
        return this.data.RemoveObject();
    }
}

