/*
 * Decompiled with CFR 0.152.
 */
package JavaGroups;

import JavaGroups.Address;
import JavaGroups.OID;
import java.net.InetAddress;

public class McastAddress
extends Address {
    private OID pid;
    private int port;
    private String groupname;

    public McastAddress(String mcast_addr, int p, String name) throws Exception {
        this.pid = OID.MakePid(InetAddress.getByName(mcast_addr));
        this.pid.SetProcessId(0L);
        this.port = p;
        this.groupname = name;
    }

    public McastAddress(InetAddress mcast_addr, int p, String name) throws Exception {
        this.pid = OID.MakePid(mcast_addr);
        this.pid.SetProcessId(0L);
        this.port = p;
        this.groupname = name;
    }

    public OID GetOid() {
        return this.pid;
    }

    public InetAddress GetAddress() {
        return this.pid.GetAddress();
    }

    public long GetProcessId() {
        return this.pid.GetProcessId();
    }

    public int GetPort() {
        return this.port;
    }

    public String GetGroupName() {
        return this.groupname;
    }

    public void SetPort(int p) {
        this.port = p;
    }

    public void SetProcessId(long id) {
        this.pid.SetProcessId(id);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(String.valueOf(this.pid) + ":");
        if (this.port != 0) {
            ret.append(this.port);
        } else {
            ret.append("<no port>");
        }
        ret.append(":");
        if (this.groupname != null) {
            ret.append(this.groupname);
        } else {
            ret.append("<no grp>");
        }
        return ret.toString();
    }
}

