package JavaGroups;

import java.net.*;
import JavaGroups.JavaStack.Address;


/**
 * ViewIds are used for ordering views (each view has a ViewId and a list of members).
 * Ordering between views is important for example in a virtual synchrony protocol where
 * all views seen by a member have to be ordered.
 */
public class ViewId implements java.io.Serializable {
    Object        coord_addr=null;   // Address of the issuer of this view
    long          id=0;              // Lamport time of the view


    
    public ViewId(Object coord_addr) {
	this.coord_addr=coord_addr;
    }


    public ViewId(Object coord_addr, long id) {
	this.coord_addr=coord_addr;
	this.id=id;
    }

    public long     GetId()                            {return id;}

    /** @deprecated Since ViewIds should be immutable, this method will be removed soon !  */
    public void     SetId(long new_id)                 {id=new_id;}


    public Object   GetCoordAddress()                  {return coord_addr;}
    public void     SetCoordAddress(Object new_addr)   {coord_addr=new_addr;}
    

    //    public synchronized void Increment() {
    //id++;
    //}
    

    public String toString() {
	return "[" + coord_addr + "|" + id + "]";
    }

    public ViewId Copy() {
	return new ViewId(coord_addr, id);
    }



    /**
     * Establishes an order between 2 ViewIds. First compare on id. <em>Compare on coord_addr
     * only if necessary</em> (i.e. ids are equal) !
     * @return 0 for equality, value less than 0 if smaller, greater than 0 if greater.
     */
    public int Compare(ViewId other) {
	int rc;

	try {
	    return id > other.id ? 1 : id < other.id ? -1 : 0;
	}
	catch(NullPointerException e) {
	    System.err.println("ViewId.Compare(): " + e);
	    throw e;
	}
    }



    public boolean equals(Object other_view) {
	return Compare((ViewId)other_view) == 0 ? true : false;
    }


    public int hashCode() {
	return (int)id;
    }


    public static void main(String args[]) {
	ViewId  v1, v2, v3;
	int     rc;

	try {
	    v1=new ViewId(new Address(InetAddress.getByName("janet"), 1000), 22);
	    v2=new ViewId(new Address(InetAddress.getByName("gulag"), 1000), 21);

	    v3=v1.Copy();
	    rc=v1.Compare(v2);
	    System.out.println("v1=" + v1 + "\nv2=" + v2 + "\nrc=" + rc + "\nv3=" + v3);
	}
	catch(Exception e) {
	    System.err.println(e);
	}

    }
}
