package JavaGroups.JavaStack.Protocols;

import java.io.*;
import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;




/**
   Used by a client until it becomes a member: all up messages are discarded until a VIEW_CHANGE
   is encountered. From then on, this layer just acts as a pass-through layer. later, we may
   add some functionality that checks for the VIDs of messages and discards messages accordingly.
 */

public class VIEW_ENFORCER extends Protocol {
    boolean  trace=false;
    Object   local_addr=null;
    boolean  is_member=false;


    /** All protocol names have to be unique ! */
    public String  GetName() {return "VIEW_ENFORCER";}


    public boolean SetProperties(Properties props) {
	String     str;

	this.props=props;
	str=props.getProperty("trace");
	if(str != null) {
	    trace=new Boolean(str).booleanValue();
	    props.remove("trace");
	}
	if(props.size() > 0) {
	    System.err.println("VIEW_ENFORCER.SetProperties(): these properties are not recognized:");
	    props.list(System.out);
	    return false;
	}
	return true;
    }





    public void Up(Event evt) {
	Message msg;




	switch(evt.GetType()) {

	case Event.VIEW_CHANGE:
	    if(is_member)       // pass the view change up if we are already a member of the group
		break;

	    Vector new_members=(Vector)((View)evt.GetArg()).GetMembers();
	    if(new_members == null || new_members.size() == 0)
		break;
	    if(local_addr == null) {
		System.err.println("VIEW_ENFORCER.Up(VIEW_CHANGE): local address is null; cannot check " +
				   "whether I'm a member of the group; discarding view change");
		return;
	    }

	    if(new_members.contains(local_addr))
		is_member=true;
	    else
		return;
	    
	    break;

	case Event.SET_LOCAL_ADDRESS:
	    local_addr=evt.GetArg();
	    break;


	case Event.MSG:
	    if(!is_member) {    // drop message if we are not yet member of the group
		if(trace) System.out.println("VIEW_ENFORCER: dropping message " + evt.GetArg());
		return;
	    }
	    break;

	}
	PassUp(evt);            // Pass up to the layer above us
    }



}
