package JavaGroups.JavaStack.Protocols;

import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;


public class PRINTOBJS extends Protocol {

    public PRINTOBJS() {}

    public String        GetName()             {return "PRINTOBJS";}


    public void Up(Event evt) {
	Object       obj=null;
	byte[]       buf;
    	Message      msg;

	if(evt.GetType() != Event.MSG) {
	    System.out.println("------------ PRINTOBJS (received event) ----------------");
	    System.out.println(evt);
	    System.out.println("--------------------------------------------------------");
	    PassUp(evt);
	    return;
	}

	msg=(Message)evt.GetArg();
	buf=msg.GetBuffer();
	if(buf != null) {
	    try {
		obj=Util.ObjectFromByteBuffer(buf);
	    }
	    catch(ClassCastException cast_ex) {
		System.out.println("------------ PRINTOBJS (received) ----------------------");
		System.out.println(msg);
		System.out.println("--------------------------------------------------------");
		PassUp(evt);
		return;		
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }

	    System.out.println("------------ PRINTOBJS (received) ----------------------");
	    System.out.println(obj);
	    System.out.println("--------------------------------------------------------");
	}
	else
	    System.out.println("------- PRINTOBJS (received null msg from " + msg.GetSrc() + ", headers are " +
			       msg.PrintObjectHeaders() + ") --------");

	PassUp(evt);
    }
    


    public void Down(Event evt) {
	Object       obj=null;
	byte[]       buf;
	Message      msg;

	if(evt.GetType() != Event.MSG) {
	    System.out.println("------------ PRINTOBJS (sent event) --------------------");
	    System.out.println(evt);
	    System.out.println("--------------------------------------------------------");
	    PassDown(evt);
	    return;
	}

	msg=(Message)evt.GetArg();
	buf=msg.GetBuffer();
	if(buf != null) {
	    try {
		obj=Util.ObjectFromByteBuffer(buf);
	    }
	    catch(ClassCastException cast_ex) {
		System.out.println("------------ PRINTOBJS (sent) --------------------------");
		System.out.println(msg);
		System.out.println("--------------------------------------------------------");
		PassDown(evt);
		return;		
	    }
	    catch(Exception e) {
		System.err.println(e);
	    }

	    System.out.println("------------ PRINTOBJS (sent) --------------------------");
	    System.out.println(obj);
	    System.out.println("--------------------------------------------------------");
	}
	else
	    System.out.println("------- PRINTOBJS (sent null msg to " + msg.GetDest() + ", headers are " +
			       msg.PrintObjectHeaders() + " ) -------------");

	PassDown(evt);
    }


    public void Reset() {System.out.println("PRINTOBJS protocol is reset");}

    public String toString() {
	return "Protocol PRINTOBJS";
    }


}
