package JavaGroups.JavaStack.Protocols;

import java.io.Serializable;
import JavaGroups.*;

/**
   Message digest, collecting the highest sequence number seen so far for each member, plus the
   messages that have higher seqnos than the ones given.
 */
public class Digest implements Serializable {
    public long[]     highest_seqnos=null; // highest seqno received for each member
    public List       msgs=new List();     // msgs (for each member) whose seqnos are higher than the 
                                           // ones sent by the FLUSH coordinator
    public Digest(int size) {
	highest_seqnos=new long[size];
    }

    public String toString() {
	StringBuffer retval=new StringBuffer();
	retval.append(Util.Array2String(highest_seqnos) + " (" + msgs.Size() + " msgs)");
	return retval.toString();
    }
    
}
