package JavaGroups.JavaStack.Protocols;

import java.io.*;
import java.util.*;
import JavaGroups.*;
import JavaGroups.JavaStack.*;



/**

 */

public class DUMMY extends Protocol {
    boolean  trace=false;
    Vector   members=new Vector();
    String   name="DUMMY";

    /** All protocol names have to be unique ! */
    public String  GetName() {return name;}


    public boolean SetProperties(Properties props) {
	String     str;

	this.props=props;
	str=props.getProperty("trace");
	if(str != null) {
	    trace=new Boolean(str).booleanValue();
	    props.remove("trace");
	}

	str=props.getProperty("name");
	if(str != null) {
	    name=str;
	    props.remove("name");
	}



	if(props.size() > 0) {
	    System.err.println("DUMMY.SetProperties(): these properties are not recognized:");
	    props.list(System.out);
	    return false;
	}
	return true;
    }


    /** Just remove if you don't need to reset any state */
    public void Reset() {}




    public void Up(Event evt) {
	Message msg;

	switch(evt.GetType()) {

	case Event.START:
	    System.out.println(name + " started");
	    break;

	case Event.MSG:
	    msg=(Message)evt.GetArg();
	    // Do something with the event, e.g. extract the message and remove a header.
	    // Optionally pass up
	    break;
	}

	PassUp(evt);            // Pass up to the layer above us
    }





    public void Down(Event evt) {
	Message msg;

	switch(evt.GetType()) {
	case Event.STOP:
	    System.out.println(name + " stopped");
	    break;

	case Event.TMP_VIEW:
	case Event.VIEW_CHANGE:
	    Vector new_members=(Vector)((View)evt.GetArg()).GetMembers();
	    synchronized(members) {
		members.removeAllElements();
		if(new_members != null && new_members.size() > 0)
		    for(int i=0; i < new_members.size(); i++)
			members.addElement(new_members.elementAt(i));
	    }
	    PassDown(evt);
	    break;

	case Event.MSG:
	    msg=(Message)evt.GetArg();
	    //System.out.println(name + ": Down");
	    break;
	}

	PassDown(evt);          // Pass on to the layer below us
    }



}
